@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin

import com.pulumi.aws.rolesanywhere.kotlin.outputs.TrustAnchorSource
import com.pulumi.aws.rolesanywhere.kotlin.outputs.TrustAnchorSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TrustAnchor].
 */
@PulumiTagMarker
public class TrustAnchorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustAnchorArgs = TrustAnchorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustAnchorArgsBuilder.() -> Unit) {
        val builder = TrustAnchorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrustAnchor {
        val builtJavaResource = com.pulumi.aws.rolesanywhere.TrustAnchor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrustAnchor(builtJavaResource)
    }
}

/**
 * Resource for managing a Roles Anywhere Trust Anchor.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificate;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs;
 * import com.pulumi.aws.rolesanywhere.TrustAnchor;
 * import com.pulumi.aws.rolesanywhere.TrustAnchorArgs;
 * import com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceArgs;
 * import com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceSourceDataArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .permanentDeletionTimeInDays(7)
 *             .type("ROOT")
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         var testCertificate = new Certificate("testCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(exampleCertificateAuthority.certificateSigningRequest())
 *             .signingAlgorithm("SHA512WITHRSA")
 *             .templateArn(String.format("arn:%s:acm-pca:::template/RootCACertificate/V1", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *         var exampleCertificateAuthorityCertificate = new CertificateAuthorityCertificate("exampleCertificateAuthorityCertificate", CertificateAuthorityCertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificate(aws_acmpca_certificate.example().certificate())
 *             .certificateChain(aws_acmpca_certificate.example().certificate_chain())
 *             .build());
 *         var testTrustAnchor = new TrustAnchor("testTrustAnchor", TrustAnchorArgs.builder()
 *             .source(TrustAnchorSourceArgs.builder()
 *                 .sourceData(TrustAnchorSourceSourceDataArgs.builder()
 *                     .acmPcaArn(exampleCertificateAuthority.arn())
 *                     .build())
 *                 .sourceType("AWS_ACM_PCA")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleCertificateAuthorityCertificate)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_rolesanywhere_trust_anchor` using its `id`. For example:
 * ```sh
 *  $ pulumi import aws:rolesanywhere/trustAnchor:TrustAnchor example 92b2fbbb-984d-41a3-a765-e3cbdb69ebb1
 * ```
 *
 */
public class TrustAnchor internal constructor(
    override val javaResource: com.pulumi.aws.rolesanywhere.TrustAnchor,
) : KotlinCustomResource(javaResource, TrustAnchorMapper) {
    /**
     * Amazon Resource Name (ARN) of the Trust Anchor
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether or not the Trust Anchor should be enabled.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The name of the Trust Anchor.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The source of trust, documented below
     */
    public val source: Output<TrustAnchorSource>
        get() = javaResource.source().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TrustAnchorMapper : ResourceMapper<TrustAnchor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rolesanywhere.TrustAnchor::class == javaResource::class

    override fun map(javaResource: Resource): TrustAnchor = TrustAnchor(
        javaResource as
            com.pulumi.aws.rolesanywhere.TrustAnchor,
    )
}

/**
 * @see [TrustAnchor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustAnchor].
 */
public suspend fun trustAnchor(name: String, block: suspend TrustAnchorResourceBuilder.() -> Unit):
    TrustAnchor {
    val builder = TrustAnchorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustAnchor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustAnchor(name: String): TrustAnchor {
    val builder = TrustAnchorResourceBuilder()
    builder.name(name)
    return builder.build()
}
