@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin

import com.pulumi.aws.rolesanywhere.TrustAnchorArgs.builder
import com.pulumi.aws.rolesanywhere.kotlin.inputs.TrustAnchorSourceArgs
import com.pulumi.aws.rolesanywhere.kotlin.inputs.TrustAnchorSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Roles Anywhere Trust Anchor.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.acmpca.CertificateAuthority;
 * import com.pulumi.aws.acmpca.CertificateAuthorityArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.acmpca.Certificate;
 * import com.pulumi.aws.acmpca.CertificateArgs;
 * import com.pulumi.aws.acmpca.inputs.CertificateValidityArgs;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificate;
 * import com.pulumi.aws.acmpca.CertificateAuthorityCertificateArgs;
 * import com.pulumi.aws.rolesanywhere.TrustAnchor;
 * import com.pulumi.aws.rolesanywhere.TrustAnchorArgs;
 * import com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceArgs;
 * import com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceSourceDataArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCertificateAuthority = new CertificateAuthority("exampleCertificateAuthority", CertificateAuthorityArgs.builder()
 *             .permanentDeletionTimeInDays(7)
 *             .type("ROOT")
 *             .certificateAuthorityConfiguration(CertificateAuthorityCertificateAuthorityConfigurationArgs.builder()
 *                 .keyAlgorithm("RSA_4096")
 *                 .signingAlgorithm("SHA512WITHRSA")
 *                 .subject(CertificateAuthorityCertificateAuthorityConfigurationSubjectArgs.builder()
 *                     .commonName("example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         final var current = AwsFunctions.getPartition();
 *         var testCertificate = new Certificate("testCertificate", CertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificateSigningRequest(exampleCertificateAuthority.certificateSigningRequest())
 *             .signingAlgorithm("SHA512WITHRSA")
 *             .templateArn(String.format("arn:%s:acm-pca:::template/RootCACertificate/V1", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .validity(CertificateValidityArgs.builder()
 *                 .type("YEARS")
 *                 .value(1)
 *                 .build())
 *             .build());
 *         var exampleCertificateAuthorityCertificate = new CertificateAuthorityCertificate("exampleCertificateAuthorityCertificate", CertificateAuthorityCertificateArgs.builder()
 *             .certificateAuthorityArn(exampleCertificateAuthority.arn())
 *             .certificate(aws_acmpca_certificate.example().certificate())
 *             .certificateChain(aws_acmpca_certificate.example().certificate_chain())
 *             .build());
 *         var testTrustAnchor = new TrustAnchor("testTrustAnchor", TrustAnchorArgs.builder()
 *             .source(TrustAnchorSourceArgs.builder()
 *                 .sourceData(TrustAnchorSourceSourceDataArgs.builder()
 *                     .acmPcaArn(exampleCertificateAuthority.arn())
 *                     .build())
 *                 .sourceType("AWS_ACM_PCA")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleCertificateAuthorityCertificate)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_rolesanywhere_trust_anchor` using its `id`. For example:
 * ```sh
 *  $ pulumi import aws:rolesanywhere/trustAnchor:TrustAnchor example 92b2fbbb-984d-41a3-a765-e3cbdb69ebb1
 * ```
 * @property enabled Whether or not the Trust Anchor should be enabled.
 * @property name The name of the Trust Anchor.
 * @property source The source of trust, documented below
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TrustAnchorArgs(
    public val enabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val source: Output<TrustAnchorSourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rolesanywhere.TrustAnchorArgs> {
    override fun toJava(): com.pulumi.aws.rolesanywhere.TrustAnchorArgs =
        com.pulumi.aws.rolesanywhere.TrustAnchorArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrustAnchorArgs].
 */
@PulumiTagMarker
public class TrustAnchorArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var source: Output<TrustAnchorSourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether or not the Trust Anchor should be enabled.
     */
    @JvmName("fevaaprffvfunluk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the Trust Anchor.
     */
    @JvmName("uaqeyvqwvyjnsycn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The source of trust, documented below
     */
    @JvmName("bdbnilmftwhiwfxy")
    public suspend fun source(`value`: Output<TrustAnchorSourceArgs>) {
        this.source = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ufnvkkrwywpbbctf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether or not the Trust Anchor should be enabled.
     */
    @JvmName("kequxbyrsrkfpdtw")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the Trust Anchor.
     */
    @JvmName("iixsjkudcxurqdxv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The source of trust, documented below
     */
    @JvmName("nrtjrvtfrvtbpjyf")
    public suspend fun source(`value`: TrustAnchorSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source of trust, documented below
     */
    @JvmName("xtscvuoavnpockuv")
    public suspend fun source(argument: suspend TrustAnchorSourceArgsBuilder.() -> Unit) {
        val toBeMapped = TrustAnchorSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("drlhinurippopsll")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qvgbvpmdcikoebtv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrustAnchorArgs = TrustAnchorArgs(
        enabled = enabled,
        name = name,
        source = source,
        tags = tags,
    )
}
