@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin.inputs

import com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceData The data denoting the source of trust, documented below
 * @property sourceType The type of the source of trust. Must be either `AWS_ACM_PCA` or `CERTIFICATE_BUNDLE`.
 */
public data class TrustAnchorSourceArgs(
    public val sourceData: Output<TrustAnchorSourceSourceDataArgs>,
    public val sourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceArgs> {
    override fun toJava(): com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceArgs =
        com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceArgs.builder()
            .sourceData(sourceData.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceType(sourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustAnchorSourceArgs].
 */
@PulumiTagMarker
public class TrustAnchorSourceArgsBuilder internal constructor() {
    private var sourceData: Output<TrustAnchorSourceSourceDataArgs>? = null

    private var sourceType: Output<String>? = null

    /**
     * @param value The data denoting the source of trust, documented below
     */
    @JvmName("thbjtvyyysrchmoe")
    public suspend fun sourceData(`value`: Output<TrustAnchorSourceSourceDataArgs>) {
        this.sourceData = value
    }

    /**
     * @param value The type of the source of trust. Must be either `AWS_ACM_PCA` or `CERTIFICATE_BUNDLE`.
     */
    @JvmName("tcygihgwabepsuwo")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The data denoting the source of trust, documented below
     */
    @JvmName("rdeplqcmxeaxovae")
    public suspend fun sourceData(`value`: TrustAnchorSourceSourceDataArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceData = mapped
    }

    /**
     * @param argument The data denoting the source of trust, documented below
     */
    @JvmName("cfkgkakxgfoxinpe")
    public suspend
    fun sourceData(argument: suspend TrustAnchorSourceSourceDataArgsBuilder.() -> Unit) {
        val toBeMapped = TrustAnchorSourceSourceDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceData = mapped
    }

    /**
     * @param value The type of the source of trust. Must be either `AWS_ACM_PCA` or `CERTIFICATE_BUNDLE`.
     */
    @JvmName("mwvmbllnmtucitab")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): TrustAnchorSourceArgs = TrustAnchorSourceArgs(
        sourceData = sourceData ?: throw PulumiNullFieldException("sourceData"),
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
    )
}
