@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin.inputs

import com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceSourceDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property acmPcaArn The ARN of an ACM Private Certificate Authority.
 * @property x509CertificateData
 */
public data class TrustAnchorSourceSourceDataArgs(
    public val acmPcaArn: Output<String>? = null,
    public val x509CertificateData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceSourceDataArgs> {
    override fun toJava(): com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceSourceDataArgs =
        com.pulumi.aws.rolesanywhere.inputs.TrustAnchorSourceSourceDataArgs.builder()
            .acmPcaArn(acmPcaArn?.applyValue({ args0 -> args0 }))
            .x509CertificateData(x509CertificateData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustAnchorSourceSourceDataArgs].
 */
@PulumiTagMarker
public class TrustAnchorSourceSourceDataArgsBuilder internal constructor() {
    private var acmPcaArn: Output<String>? = null

    private var x509CertificateData: Output<String>? = null

    /**
     * @param value The ARN of an ACM Private Certificate Authority.
     */
    @JvmName("wuhigcewmvunteot")
    public suspend fun acmPcaArn(`value`: Output<String>) {
        this.acmPcaArn = value
    }

    /**
     * @param value
     */
    @JvmName("hjayvnrqenogxlex")
    public suspend fun x509CertificateData(`value`: Output<String>) {
        this.x509CertificateData = value
    }

    /**
     * @param value The ARN of an ACM Private Certificate Authority.
     */
    @JvmName("ojfeokehxidbfgmy")
    public suspend fun acmPcaArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acmPcaArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("mboeqsmrevxcioil")
    public suspend fun x509CertificateData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509CertificateData = mapped
    }

    internal fun build(): TrustAnchorSourceSourceDataArgs = TrustAnchorSourceSourceDataArgs(
        acmPcaArn = acmPcaArn,
        x509CertificateData = x509CertificateData,
    )
}
