@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rolesanywhere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acmPcaArn The ARN of an ACM Private Certificate Authority.
 * @property x509CertificateData
 */
public data class TrustAnchorSourceSourceData(
    public val acmPcaArn: String? = null,
    public val x509CertificateData: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rolesanywhere.outputs.TrustAnchorSourceSourceData):
            TrustAnchorSourceSourceData = TrustAnchorSourceSourceData(
            acmPcaArn = javaType.acmPcaArn().map({ args0 -> args0 }).orElse(null),
            x509CertificateData = javaType.x509CertificateData().map({ args0 -> args0 }).orElse(null),
        )
    }
}
