@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [CidrLocation].
 */
@PulumiTagMarker
public class CidrLocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CidrLocationArgs = CidrLocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CidrLocationArgsBuilder.() -> Unit) {
        val builder = CidrLocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CidrLocation {
        val builtJavaResource = com.pulumi.aws.route53.CidrLocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CidrLocation(builtJavaResource)
    }
}

/**
 * Provides a Route53 CIDR location resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.CidrCollection;
 * import com.pulumi.aws.route53.CidrLocation;
 * import com.pulumi.aws.route53.CidrLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCidrCollection = new CidrCollection("exampleCidrCollection");
 *         var exampleCidrLocation = new CidrLocation("exampleCidrLocation", CidrLocationArgs.builder()
 *             .cidrCollectionId(exampleCidrCollection.id())
 *             .cidrBlocks(
 *                 "200.5.3.0/24",
 *                 "200.6.3.0/24")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CIDR locations using their the CIDR collection ID and location name. For example:
 * ```sh
 *  $ pulumi import aws:route53/cidrLocation:CidrLocation example 9ac32814-3e67-0932-6048-8d779cc6f511,office
 * ```
 *
 */
public class CidrLocation internal constructor(
    override val javaResource: com.pulumi.aws.route53.CidrLocation,
) : KotlinCustomResource(javaResource, CidrLocationMapper) {
    /**
     * CIDR blocks for the location.
     */
    public val cidrBlocks: Output<List<String>>
        get() = javaResource.cidrBlocks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the CIDR collection to update.
     */
    public val cidrCollectionId: Output<String>
        get() = javaResource.cidrCollectionId().applyValue({ args0 -> args0 })

    /**
     * Name for the CIDR location.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object CidrLocationMapper : ResourceMapper<CidrLocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.CidrLocation::class == javaResource::class

    override fun map(javaResource: Resource): CidrLocation = CidrLocation(
        javaResource as
            com.pulumi.aws.route53.CidrLocation,
    )
}

/**
 * @see [CidrLocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CidrLocation].
 */
public suspend fun cidrLocation(
    name: String,
    block: suspend CidrLocationResourceBuilder.() -> Unit,
): CidrLocation {
    val builder = CidrLocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CidrLocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cidrLocation(name: String): CidrLocation {
    val builder = CidrLocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
