@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.CidrLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Route53 CIDR location resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.CidrCollection;
 * import com.pulumi.aws.route53.CidrLocation;
 * import com.pulumi.aws.route53.CidrLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCidrCollection = new CidrCollection("exampleCidrCollection");
 *         var exampleCidrLocation = new CidrLocation("exampleCidrLocation", CidrLocationArgs.builder()
 *             .cidrCollectionId(exampleCidrCollection.id())
 *             .cidrBlocks(
 *                 "200.5.3.0/24",
 *                 "200.6.3.0/24")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CIDR locations using their the CIDR collection ID and location name. For example:
 * ```sh
 *  $ pulumi import aws:route53/cidrLocation:CidrLocation example 9ac32814-3e67-0932-6048-8d779cc6f511,office
 * ```
 * @property cidrBlocks CIDR blocks for the location.
 * @property cidrCollectionId The ID of the CIDR collection to update.
 * @property name Name for the CIDR location.
 */
public data class CidrLocationArgs(
    public val cidrBlocks: Output<List<String>>? = null,
    public val cidrCollectionId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.CidrLocationArgs> {
    override fun toJava(): com.pulumi.aws.route53.CidrLocationArgs =
        com.pulumi.aws.route53.CidrLocationArgs.builder()
            .cidrBlocks(cidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cidrCollectionId(cidrCollectionId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CidrLocationArgs].
 */
@PulumiTagMarker
public class CidrLocationArgsBuilder internal constructor() {
    private var cidrBlocks: Output<List<String>>? = null

    private var cidrCollectionId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value CIDR blocks for the location.
     */
    @JvmName("nbhgflbbldgkvbht")
    public suspend fun cidrBlocks(`value`: Output<List<String>>) {
        this.cidrBlocks = value
    }

    @JvmName("furndaeshjdwngks")
    public suspend fun cidrBlocks(vararg values: Output<String>) {
        this.cidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values CIDR blocks for the location.
     */
    @JvmName("vhdrixefbnncofyx")
    public suspend fun cidrBlocks(values: List<Output<String>>) {
        this.cidrBlocks = Output.all(values)
    }

    /**
     * @param value The ID of the CIDR collection to update.
     */
    @JvmName("wbxcnrwtxoolqful")
    public suspend fun cidrCollectionId(`value`: Output<String>) {
        this.cidrCollectionId = value
    }

    /**
     * @param value Name for the CIDR location.
     */
    @JvmName("deiactydpuevaxqw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value CIDR blocks for the location.
     */
    @JvmName("ljegnehcvcjkfnub")
    public suspend fun cidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param values CIDR blocks for the location.
     */
    @JvmName("axpwbemoygiyxtxs")
    public suspend fun cidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param value The ID of the CIDR collection to update.
     */
    @JvmName("kpxtqgjvberjojxw")
    public suspend fun cidrCollectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrCollectionId = mapped
    }

    /**
     * @param value Name for the CIDR location.
     */
    @JvmName("tyssvpqmmnafsvey")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CidrLocationArgs = CidrLocationArgs(
        cidrBlocks = cidrBlocks,
        cidrCollectionId = cidrCollectionId,
        name = name,
    )
}
