@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.DelegationSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a [Route53 Delegation Set](https://docs.aws.amazon.com/Route53/latest/APIReference/API-actions-by-function.html#actions-by-function-reusable-delegation-sets) resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.DelegationSet;
 * import com.pulumi.aws.route53.DelegationSetArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new DelegationSet("main", DelegationSetArgs.builder()
 *             .referenceName("DynDNS")
 *             .build());
 *         var primary = new Zone("primary", ZoneArgs.builder()
 *             .delegationSetId(main.id())
 *             .build());
 *         var secondary = new Zone("secondary", ZoneArgs.builder()
 *             .delegationSetId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Delegation Sets using the delegation set `id`. For example:
 * ```sh
 *  $ pulumi import aws:route53/delegationSet:DelegationSet set1 N1PA6795SAMPLE
 * ```
 * @property referenceName This is a reference name used in Caller Reference
 * (helpful for identifying single delegation set amongst others)
 */
public data class DelegationSetArgs(
    public val referenceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.DelegationSetArgs> {
    override fun toJava(): com.pulumi.aws.route53.DelegationSetArgs =
        com.pulumi.aws.route53.DelegationSetArgs.builder()
            .referenceName(referenceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegationSetArgs].
 */
@PulumiTagMarker
public class DelegationSetArgsBuilder internal constructor() {
    private var referenceName: Output<String>? = null

    /**
     * @param value This is a reference name used in Caller Reference
     * (helpful for identifying single delegation set amongst others)
     */
    @JvmName("nnmadvdcbkvvrsya")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value This is a reference name used in Caller Reference
     * (helpful for identifying single delegation set amongst others)
     */
    @JvmName("gkmxmpsgmwkwwphy")
    public suspend fun referenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    internal fun build(): DelegationSetArgs = DelegationSetArgs(
        referenceName = referenceName,
    )
}
