@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [HealthCheck].
 */
@PulumiTagMarker
public class HealthCheckResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HealthCheckArgs = HealthCheckArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HealthCheckArgsBuilder.() -> Unit) {
        val builder = HealthCheckArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HealthCheck {
        val builtJavaResource = com.pulumi.aws.route53.HealthCheck(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HealthCheck(builtJavaResource)
    }
}

/**
 * Provides a Route53 health check.
 * ## Example Usage
 * ### Connectivity and HTTP Status Code Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheck("example", HealthCheckArgs.builder()
 *             .failureThreshold("5")
 *             .fqdn("example.com")
 *             .port(80)
 *             .requestInterval("30")
 *             .resourcePath("/")
 *             .tags(Map.of("Name", "tf-test-health-check"))
 *             .type("HTTP")
 *             .build());
 *     }
 * }
 * ```
 * ### Connectivity and String Matching Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheck("example", HealthCheckArgs.builder()
 *             .failureThreshold("5")
 *             .fqdn("example.com")
 *             .port(443)
 *             .requestInterval("30")
 *             .resourcePath("/")
 *             .searchString("example")
 *             .type("HTTPS_STR_MATCH")
 *             .build());
 *     }
 * }
 * ```
 * ### Aggregate Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new HealthCheck("parent", HealthCheckArgs.builder()
 *             .type("CALCULATED")
 *             .childHealthThreshold(1)
 *             .childHealthchecks(aws_route53_health_check.child().id())
 *             .tags(Map.of("Name", "tf-test-calculated-health-check"))
 *             .build());
 *     }
 * }
 * ```
 * ### CloudWatch Alarm Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new MetricAlarm("foobar", MetricAlarmArgs.builder()
 *             .comparisonOperator("GreaterThanOrEqualToThreshold")
 *             .evaluationPeriods("2")
 *             .metricName("CPUUtilization")
 *             .namespace("AWS/EC2")
 *             .period("120")
 *             .statistic("Average")
 *             .threshold("80")
 *             .alarmDescription("This metric monitors ec2 cpu utilization")
 *             .build());
 *         var foo = new HealthCheck("foo", HealthCheckArgs.builder()
 *             .type("CLOUDWATCH_METRIC")
 *             .cloudwatchAlarmName(foobar.name())
 *             .cloudwatchAlarmRegion("us-west-2")
 *             .insufficientDataHealthStatus("Healthy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Health Checks using the health check `id`. For example:
 * ```sh
 *  $ pulumi import aws:route53/healthCheck:HealthCheck http_check abcdef11-2222-3333-4444-555555fedcba
 * ```
 *
 */
public class HealthCheck internal constructor(
    override val javaResource: com.pulumi.aws.route53.HealthCheck,
) : KotlinCustomResource(javaResource, HealthCheckMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Health Check.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
     */
    public val childHealthThreshold: Output<Int>?
        get() = javaResource.childHealthThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     */
    public val childHealthchecks: Output<List<String>>?
        get() = javaResource.childHealthchecks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the CloudWatch alarm.
     */
    public val cloudwatchAlarmName: Output<String>?
        get() = javaResource.cloudwatchAlarmName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The CloudWatchRegion that the CloudWatch alarm was created in.
     */
    public val cloudwatchAlarmRegion: Output<String>?
        get() = javaResource.cloudwatchAlarmRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
     * * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
     * * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
     * * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
     * > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
     */
    public val disabled: Output<Boolean>?
        get() = javaResource.disabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
     */
    public val enableSni: Output<Boolean>
        get() = javaResource.enableSni().applyValue({ args0 -> args0 })

    /**
     * The number of consecutive health checks that an endpoint must pass or fail.
     */
    public val failureThreshold: Output<Int>
        get() = javaResource.failureThreshold().applyValue({ args0 -> args0 })

    /**
     * The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
     */
    public val fqdn: Output<String>?
        get() = javaResource.fqdn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
     */
    public val insufficientDataHealthStatus: Output<String>?
        get() = javaResource.insufficientDataHealthStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
     */
    public val invertHealthcheck: Output<Boolean>?
        get() = javaResource.invertHealthcheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP address of the endpoint to be checked.
     */
    public val ipAddress: Output<String>?
        get() = javaResource.ipAddress().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
     */
    public val measureLatency: Output<Boolean>?
        get() = javaResource.measureLatency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port of the endpoint to be checked.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This is a reference name used in Caller Reference
     * (helpful for identifying single health_check set amongst others)
     */
    public val referenceName: Output<String>?
        get() = javaResource.referenceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     */
    public val regions: Output<List<String>>?
        get() = javaResource.regions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
     */
    public val requestInterval: Output<Int>?
        get() = javaResource.requestInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path that you want Amazon Route 53 to request when performing health checks.
     */
    public val resourcePath: Output<String>?
        get() = javaResource.resourcePath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
     */
    public val routingControlArn: Output<String>?
        get() = javaResource.routingControlArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
     */
    public val searchString: Output<String>?
        get() = javaResource.searchString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HealthCheckMapper : ResourceMapper<HealthCheck> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.HealthCheck::class == javaResource::class

    override fun map(javaResource: Resource): HealthCheck = HealthCheck(
        javaResource as
            com.pulumi.aws.route53.HealthCheck,
    )
}

/**
 * @see [HealthCheck].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HealthCheck].
 */
public suspend fun healthCheck(name: String, block: suspend HealthCheckResourceBuilder.() -> Unit):
    HealthCheck {
    val builder = HealthCheckResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HealthCheck].
 * @param name The _unique_ name of the resulting resource.
 */
public fun healthCheck(name: String): HealthCheck {
    val builder = HealthCheckResourceBuilder()
    builder.name(name)
    return builder.build()
}
