@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.HealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Route53 health check.
 * ## Example Usage
 * ### Connectivity and HTTP Status Code Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheck("example", HealthCheckArgs.builder()
 *             .failureThreshold("5")
 *             .fqdn("example.com")
 *             .port(80)
 *             .requestInterval("30")
 *             .resourcePath("/")
 *             .tags(Map.of("Name", "tf-test-health-check"))
 *             .type("HTTP")
 *             .build());
 *     }
 * }
 * ```
 * ### Connectivity and String Matching Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheck("example", HealthCheckArgs.builder()
 *             .failureThreshold("5")
 *             .fqdn("example.com")
 *             .port(443)
 *             .requestInterval("30")
 *             .resourcePath("/")
 *             .searchString("example")
 *             .type("HTTPS_STR_MATCH")
 *             .build());
 *     }
 * }
 * ```
 * ### Aggregate Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new HealthCheck("parent", HealthCheckArgs.builder()
 *             .type("CALCULATED")
 *             .childHealthThreshold(1)
 *             .childHealthchecks(aws_route53_health_check.child().id())
 *             .tags(Map.of("Name", "tf-test-calculated-health-check"))
 *             .build());
 *     }
 * }
 * ```
 * ### CloudWatch Alarm Check
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new MetricAlarm("foobar", MetricAlarmArgs.builder()
 *             .comparisonOperator("GreaterThanOrEqualToThreshold")
 *             .evaluationPeriods("2")
 *             .metricName("CPUUtilization")
 *             .namespace("AWS/EC2")
 *             .period("120")
 *             .statistic("Average")
 *             .threshold("80")
 *             .alarmDescription("This metric monitors ec2 cpu utilization")
 *             .build());
 *         var foo = new HealthCheck("foo", HealthCheckArgs.builder()
 *             .type("CLOUDWATCH_METRIC")
 *             .cloudwatchAlarmName(foobar.name())
 *             .cloudwatchAlarmRegion("us-west-2")
 *             .insufficientDataHealthStatus("Healthy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Health Checks using the health check `id`. For example:
 * ```sh
 *  $ pulumi import aws:route53/healthCheck:HealthCheck http_check abcdef11-2222-3333-4444-555555fedcba
 * ```
 * @property childHealthThreshold The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
 * @property childHealthchecks For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
 * @property cloudwatchAlarmName The name of the CloudWatch alarm.
 * @property cloudwatchAlarmRegion The CloudWatchRegion that the CloudWatch alarm was created in.
 * @property disabled A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
 * * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
 * * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
 * * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
 * > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
 * @property enableSni A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
 * @property failureThreshold The number of consecutive health checks that an endpoint must pass or fail.
 * @property fqdn The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
 * @property insufficientDataHealthStatus The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
 * @property invertHealthcheck A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
 * @property ipAddress The IP address of the endpoint to be checked.
 * @property measureLatency A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
 * @property port The port of the endpoint to be checked.
 * @property referenceName This is a reference name used in Caller Reference
 * (helpful for identifying single health_check set amongst others)
 * @property regions A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
 * @property requestInterval The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
 * @property resourcePath The path that you want Amazon Route 53 to request when performing health checks.
 * @property routingControlArn The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
 * @property searchString String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
 * @property tags A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
 */
public data class HealthCheckArgs(
    public val childHealthThreshold: Output<Int>? = null,
    public val childHealthchecks: Output<List<String>>? = null,
    public val cloudwatchAlarmName: Output<String>? = null,
    public val cloudwatchAlarmRegion: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val enableSni: Output<Boolean>? = null,
    public val failureThreshold: Output<Int>? = null,
    public val fqdn: Output<String>? = null,
    public val insufficientDataHealthStatus: Output<String>? = null,
    public val invertHealthcheck: Output<Boolean>? = null,
    public val ipAddress: Output<String>? = null,
    public val measureLatency: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
    public val referenceName: Output<String>? = null,
    public val regions: Output<List<String>>? = null,
    public val requestInterval: Output<Int>? = null,
    public val resourcePath: Output<String>? = null,
    public val routingControlArn: Output<String>? = null,
    public val searchString: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.HealthCheckArgs> {
    override fun toJava(): com.pulumi.aws.route53.HealthCheckArgs =
        com.pulumi.aws.route53.HealthCheckArgs.builder()
            .childHealthThreshold(childHealthThreshold?.applyValue({ args0 -> args0 }))
            .childHealthchecks(childHealthchecks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cloudwatchAlarmName(cloudwatchAlarmName?.applyValue({ args0 -> args0 }))
            .cloudwatchAlarmRegion(cloudwatchAlarmRegion?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .enableSni(enableSni?.applyValue({ args0 -> args0 }))
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .insufficientDataHealthStatus(insufficientDataHealthStatus?.applyValue({ args0 -> args0 }))
            .invertHealthcheck(invertHealthcheck?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .measureLatency(measureLatency?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .referenceName(referenceName?.applyValue({ args0 -> args0 }))
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requestInterval(requestInterval?.applyValue({ args0 -> args0 }))
            .resourcePath(resourcePath?.applyValue({ args0 -> args0 }))
            .routingControlArn(routingControlArn?.applyValue({ args0 -> args0 }))
            .searchString(searchString?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HealthCheckArgs].
 */
@PulumiTagMarker
public class HealthCheckArgsBuilder internal constructor() {
    private var childHealthThreshold: Output<Int>? = null

    private var childHealthchecks: Output<List<String>>? = null

    private var cloudwatchAlarmName: Output<String>? = null

    private var cloudwatchAlarmRegion: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var enableSni: Output<Boolean>? = null

    private var failureThreshold: Output<Int>? = null

    private var fqdn: Output<String>? = null

    private var insufficientDataHealthStatus: Output<String>? = null

    private var invertHealthcheck: Output<Boolean>? = null

    private var ipAddress: Output<String>? = null

    private var measureLatency: Output<Boolean>? = null

    private var port: Output<Int>? = null

    private var referenceName: Output<String>? = null

    private var regions: Output<List<String>>? = null

    private var requestInterval: Output<Int>? = null

    private var resourcePath: Output<String>? = null

    private var routingControlArn: Output<String>? = null

    private var searchString: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
     */
    @JvmName("vrfaveqgeouscfnx")
    public suspend fun childHealthThreshold(`value`: Output<Int>) {
        this.childHealthThreshold = value
    }

    /**
     * @param value For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     */
    @JvmName("jebhsbxbgoddvkui")
    public suspend fun childHealthchecks(`value`: Output<List<String>>) {
        this.childHealthchecks = value
    }

    @JvmName("dajpavqlecpeacbt")
    public suspend fun childHealthchecks(vararg values: Output<String>) {
        this.childHealthchecks = Output.all(values.asList())
    }

    /**
     * @param values For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     */
    @JvmName("urneabhyfkhvoywd")
    public suspend fun childHealthchecks(values: List<Output<String>>) {
        this.childHealthchecks = Output.all(values)
    }

    /**
     * @param value The name of the CloudWatch alarm.
     */
    @JvmName("oxnpghorwpiryeni")
    public suspend fun cloudwatchAlarmName(`value`: Output<String>) {
        this.cloudwatchAlarmName = value
    }

    /**
     * @param value The CloudWatchRegion that the CloudWatch alarm was created in.
     */
    @JvmName("mxibpbnwkodhxbsl")
    public suspend fun cloudwatchAlarmRegion(`value`: Output<String>) {
        this.cloudwatchAlarmRegion = value
    }

    /**
     * @param value A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
     * * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
     * * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
     * * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
     * > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
     */
    @JvmName("xyfjpnftiqxbsqkj")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
     */
    @JvmName("hpcrapbvjwpjgoqt")
    public suspend fun enableSni(`value`: Output<Boolean>) {
        this.enableSni = value
    }

    /**
     * @param value The number of consecutive health checks that an endpoint must pass or fail.
     */
    @JvmName("xnuoxpvcrdvujkkw")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
     */
    @JvmName("ylsrcpmkjqalaucy")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
     */
    @JvmName("mlqiyesvustcxiyj")
    public suspend fun insufficientDataHealthStatus(`value`: Output<String>) {
        this.insufficientDataHealthStatus = value
    }

    /**
     * @param value A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
     */
    @JvmName("bmakldpgosfhfloe")
    public suspend fun invertHealthcheck(`value`: Output<Boolean>) {
        this.invertHealthcheck = value
    }

    /**
     * @param value The IP address of the endpoint to be checked.
     */
    @JvmName("fbwdiqufatmhsytn")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
     */
    @JvmName("xubmxmvxkljjbege")
    public suspend fun measureLatency(`value`: Output<Boolean>) {
        this.measureLatency = value
    }

    /**
     * @param value The port of the endpoint to be checked.
     */
    @JvmName("oftwprokxsjpxkxw")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value This is a reference name used in Caller Reference
     * (helpful for identifying single health_check set amongst others)
     */
    @JvmName("ufqnsjgkeihqealn")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     */
    @JvmName("wlryrlvhcwuvkkck")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("bwuyvcqqehsqnqbe")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     */
    @JvmName("bmbnxwsqkhvnfsre")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
     */
    @JvmName("rvlgrlysertwiihp")
    public suspend fun requestInterval(`value`: Output<Int>) {
        this.requestInterval = value
    }

    /**
     * @param value The path that you want Amazon Route 53 to request when performing health checks.
     */
    @JvmName("tqsfudejauxumcyo")
    public suspend fun resourcePath(`value`: Output<String>) {
        this.resourcePath = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
     */
    @JvmName("xmbcxmquksoohvvi")
    public suspend fun routingControlArn(`value`: Output<String>) {
        this.routingControlArn = value
    }

    /**
     * @param value String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
     */
    @JvmName("ftqhmwpnnlagecss")
    public suspend fun searchString(`value`: Output<String>) {
        this.searchString = value
    }

    /**
     * @param value A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iwwjgctaebrvnmgv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
     */
    @JvmName("hfyiwgojvjbumrbx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
     */
    @JvmName("jrvjlqmpwfqwmwct")
    public suspend fun childHealthThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childHealthThreshold = mapped
    }

    /**
     * @param value For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     */
    @JvmName("qqruvelevwmackdn")
    public suspend fun childHealthchecks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childHealthchecks = mapped
    }

    /**
     * @param values For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     */
    @JvmName("afamifygbuoykdpq")
    public suspend fun childHealthchecks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.childHealthchecks = mapped
    }

    /**
     * @param value The name of the CloudWatch alarm.
     */
    @JvmName("xpvgefoirsoikwqn")
    public suspend fun cloudwatchAlarmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchAlarmName = mapped
    }

    /**
     * @param value The CloudWatchRegion that the CloudWatch alarm was created in.
     */
    @JvmName("nenaewwldrksdeot")
    public suspend fun cloudwatchAlarmRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchAlarmRegion = mapped
    }

    /**
     * @param value A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
     * * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
     * * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
     * * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
     * > **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
     */
    @JvmName("ivdbklaelertxqvh")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS' defaults: when the `type` is "HTTPS" `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
     */
    @JvmName("sebftstjqjephmpy")
    public suspend fun enableSni(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSni = mapped
    }

    /**
     * @param value The number of consecutive health checks that an endpoint must pass or fail.
     */
    @JvmName("oirxfeikxcjmqgsy")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
     */
    @JvmName("proawrhgnumaxnin")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
     */
    @JvmName("grdwkuufkrgbxllx")
    public suspend fun insufficientDataHealthStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insufficientDataHealthStatus = mapped
    }

    /**
     * @param value A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
     */
    @JvmName("cqrkuutmrelsfmwh")
    public suspend fun invertHealthcheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invertHealthcheck = mapped
    }

    /**
     * @param value The IP address of the endpoint to be checked.
     */
    @JvmName("keuklewhtegowfpn")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
     */
    @JvmName("cjioqphqtiguasrl")
    public suspend fun measureLatency(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.measureLatency = mapped
    }

    /**
     * @param value The port of the endpoint to be checked.
     */
    @JvmName("fswfrlxlibxlwchg")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value This is a reference name used in Caller Reference
     * (helpful for identifying single health_check set amongst others)
     */
    @JvmName("fukcdtyaxisvgqlp")
    public suspend fun referenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     */
    @JvmName("cxpcfbpinusqvqfp")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     */
    @JvmName("hrqgkqtmrawbyhwb")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
     */
    @JvmName("emxuqxhkiaoyoykf")
    public suspend fun requestInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestInterval = mapped
    }

    /**
     * @param value The path that you want Amazon Route 53 to request when performing health checks.
     */
    @JvmName("jpvkcraluxbnltbk")
    public suspend fun resourcePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePath = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
     */
    @JvmName("vgfvbipffwromrjj")
    public suspend fun routingControlArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingControlArn = mapped
    }

    /**
     * @param value String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
     */
    @JvmName("fpawomlfqtjsqqxq")
    public suspend fun searchString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchString = mapped
    }

    /**
     * @param value A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cxwrfmiifmbrrdor")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hswuksypwnncrakb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
     */
    @JvmName("vpebfrgxamanskqp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): HealthCheckArgs = HealthCheckArgs(
        childHealthThreshold = childHealthThreshold,
        childHealthchecks = childHealthchecks,
        cloudwatchAlarmName = cloudwatchAlarmName,
        cloudwatchAlarmRegion = cloudwatchAlarmRegion,
        disabled = disabled,
        enableSni = enableSni,
        failureThreshold = failureThreshold,
        fqdn = fqdn,
        insufficientDataHealthStatus = insufficientDataHealthStatus,
        invertHealthcheck = invertHealthcheck,
        ipAddress = ipAddress,
        measureLatency = measureLatency,
        port = port,
        referenceName = referenceName,
        regions = regions,
        requestInterval = requestInterval,
        resourcePath = resourcePath,
        routingControlArn = routingControlArn,
        searchString = searchString,
        tags = tags,
        type = type,
    )
}
