@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HostedZoneDnsSec].
 */
@PulumiTagMarker
public class HostedZoneDnsSecResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedZoneDnsSecArgs = HostedZoneDnsSecArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HostedZoneDnsSecArgsBuilder.() -> Unit) {
        val builder = HostedZoneDnsSecArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HostedZoneDnsSec {
        val builtJavaResource = com.pulumi.aws.route53.HostedZoneDnsSec(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HostedZoneDnsSec(builtJavaResource)
    }
}

/**
 * Manages Route 53 Hosted Zone Domain Name System Security Extensions (DNSSEC). For more information about managing DNSSEC in Route 53, see the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec.html).
 * !> **WARNING:** If you disable DNSSEC signing for your hosted zone before the DNS changes have propagated, your domain could become unavailable on the internet. When you remove the DS records, you must wait until the longest TTL for the DS records that you remove has expired before you complete the step to disable DNSSEC signing. Please refer to the [Route 53 Developer Guide - Disable DNSSEC](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-disable.html) for a detailed breakdown on the steps required to disable DNSSEC safely for a hosted zone.
 * > **Note:** Route53 hosted zones are global resources, and as such any `aws.kms.Key` that you use as part of a signing key needs to be located in the `us-east-1` region. In the example below, the main AWS provider declaration is for `us-east-1`, however if you are provisioning your AWS resources in a different region, you will need to specify a provider alias and use that attached to the `aws.kms.Key` resource as described in the provider alias documentation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.KeySigningKey;
 * import com.pulumi.aws.route53.KeySigningKeyArgs;
 * import com.pulumi.aws.route53.HostedZoneDnsSec;
 * import com.pulumi.aws.route53.HostedZoneDnsSecArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .customerMasterKeySpec("ECC_NIST_P256")
 *             .deletionWindowInDays(7)
 *             .keyUsage("SIGN_VERIFY")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "kms:DescribeKey",
 *                                 "kms:GetPublicKey",
 *                                 "kms:Sign",
 *                                 "kms:Verify"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "dnssec-route53.amazonaws.com")
 *                             )),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Sid", "Allow Route 53 DNSSEC Service")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", "kms:*"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("AWS", String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                             )),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Sid", "Enable IAM User Permissions")
 *                         )
 *                     )),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var exampleZone = new Zone("exampleZone");
 *         var exampleKeySigningKey = new KeySigningKey("exampleKeySigningKey", KeySigningKeyArgs.builder()
 *             .hostedZoneId(exampleZone.id())
 *             .keyManagementServiceArn(exampleKey.arn())
 *             .build());
 *         var exampleHostedZoneDnsSec = new HostedZoneDnsSec("exampleHostedZoneDnsSec", HostedZoneDnsSecArgs.builder()
 *             .hostedZoneId(exampleKeySigningKey.hostedZoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleKeySigningKey)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_route53_hosted_zone_dnssec` resources using the Route 53 Hosted Zone identifier. For example:
 * ```sh
 *  $ pulumi import aws:route53/hostedZoneDnsSec:HostedZoneDnsSec example Z1D633PJN98FT9
 * ```
 *
 */
public class HostedZoneDnsSec internal constructor(
    override val javaResource: com.pulumi.aws.route53.HostedZoneDnsSec,
) : KotlinCustomResource(javaResource, HostedZoneDnsSecMapper) {
    /**
     * Identifier of the Route 53 Hosted Zone.
     * The following arguments are optional:
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Hosted Zone signing status. Valid values: `SIGNING`, `NOT_SIGNING`. Defaults to `SIGNING`.
     */
    public val signingStatus: Output<String>?
        get() = javaResource.signingStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object HostedZoneDnsSecMapper : ResourceMapper<HostedZoneDnsSec> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.HostedZoneDnsSec::class == javaResource::class

    override fun map(javaResource: Resource): HostedZoneDnsSec = HostedZoneDnsSec(
        javaResource as
            com.pulumi.aws.route53.HostedZoneDnsSec,
    )
}

/**
 * @see [HostedZoneDnsSec].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedZoneDnsSec].
 */
public suspend fun hostedZoneDnsSec(
    name: String,
    block: suspend HostedZoneDnsSecResourceBuilder.() -> Unit,
): HostedZoneDnsSec {
    val builder = HostedZoneDnsSecResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedZoneDnsSec].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedZoneDnsSec(name: String): HostedZoneDnsSec {
    val builder = HostedZoneDnsSecResourceBuilder()
    builder.name(name)
    return builder.build()
}
