@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeySigningKey].
 */
@PulumiTagMarker
public class KeySigningKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeySigningKeyArgs = KeySigningKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeySigningKeyArgsBuilder.() -> Unit) {
        val builder = KeySigningKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeySigningKey {
        val builtJavaResource = com.pulumi.aws.route53.KeySigningKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeySigningKey(builtJavaResource)
    }
}

/**
 * Manages a Route 53 Key Signing Key. To manage Domain Name System Security Extensions (DNSSEC) for a Hosted Zone, see the `aws.route53.HostedZoneDnsSec` resource. For more information about managing DNSSEC in Route 53, see the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.KeySigningKey;
 * import com.pulumi.aws.route53.KeySigningKeyArgs;
 * import com.pulumi.aws.route53.HostedZoneDnsSec;
 * import com.pulumi.aws.route53.HostedZoneDnsSecArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .customerMasterKeySpec("ECC_NIST_P256")
 *             .deletionWindowInDays(7)
 *             .keyUsage("SIGN_VERIFY")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "kms:DescribeKey",
 *                                 "kms:GetPublicKey",
 *                                 "kms:Sign"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "dnssec-route53.amazonaws.com")
 *                             )),
 *                             jsonProperty("Sid", "Allow Route 53 DNSSEC Service"),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Condition", jsonObject(
 *                                 jsonProperty("StringEquals", jsonObject(
 *                                     jsonProperty("aws:SourceAccount", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                                 )),
 *                                 jsonProperty("ArnLike", jsonObject(
 *                                     jsonProperty("aws:SourceArn", "arn:aws:route53:::hostedzone/*")
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", "kms:CreateGrant"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "dnssec-route53.amazonaws.com")
 *                             )),
 *                             jsonProperty("Sid", "Allow Route 53 DNSSEC Service to CreateGrant"),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Condition", jsonObject(
 *                                 jsonProperty("Bool", jsonObject(
 *                                     jsonProperty("kms:GrantIsForAWSResource", "true")
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", "kms:*"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("AWS", String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                             )),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Sid", "Enable IAM User Permissions")
 *                         )
 *                     )),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var exampleZone = new Zone("exampleZone");
 *         var exampleKeySigningKey = new KeySigningKey("exampleKeySigningKey", KeySigningKeyArgs.builder()
 *             .hostedZoneId(aws_route53_zone.test().id())
 *             .keyManagementServiceArn(aws_kms_key.test().arn())
 *             .build());
 *         var exampleHostedZoneDnsSec = new HostedZoneDnsSec("exampleHostedZoneDnsSec", HostedZoneDnsSecArgs.builder()
 *             .hostedZoneId(exampleKeySigningKey.hostedZoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleKeySigningKey)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_route53_key_signing_key` resources using the Route 53 Hosted Zone identifier and KMS Key identifier, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:route53/keySigningKey:KeySigningKey example Z1D633PJN98FT9,example
 * ```
 * */
 */
public class KeySigningKey internal constructor(
    override val javaResource: com.pulumi.aws.route53.KeySigningKey,
) : KotlinCustomResource(javaResource, KeySigningKeyMapper) {
    /**
     * A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3&#46;3](https://tools.ietf.org/html/rfc8624#section-3.3).
     */
    public val digestAlgorithmMnemonic: Output<String>
        get() = javaResource.digestAlgorithmMnemonic().applyValue({ args0 -> args0 })

    /**
     * An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3&#46;3](https://tools.ietf.org/html/rfc8624#section-3.3).
     */
    public val digestAlgorithmType: Output<Int>
        get() = javaResource.digestAlgorithmType().applyValue({ args0 -> args0 })

    /**
     * A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
     */
    public val digestValue: Output<String>
        get() = javaResource.digestValue().applyValue({ args0 -> args0 })

    /**
     * A string that represents a DNSKEY record.
     */
    public val dnskeyRecord: Output<String>
        get() = javaResource.dnskeyRecord().applyValue({ args0 -> args0 })

    /**
     * A string that represents a delegation signer (DS) record.
     */
    public val dsRecord: Output<String>
        get() = javaResource.dsRecord().applyValue({ args0 -> args0 })

    /**
     * An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
     */
    public val flag: Output<Int>
        get() = javaResource.flag().applyValue({ args0 -> args0 })

    /**
     * Identifier of the Route 53 Hosted Zone.
     */
    public val hostedZoneId: Output<String>
        get() = javaResource.hostedZoneId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements&#46;html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
     */
    public val keyManagementServiceArn: Output<String>
        get() = javaResource.keyManagementServiceArn().applyValue({ args0 -> args0 })

    /**
     * An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
     */
    public val keyTag: Output<Int>
        get() = javaResource.keyTag().applyValue({ args0 -> args0 })

    /**
     * Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The public key, represented as a Base64 encoding, as required by [RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })

    /**
     * A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3&#46;1](https://tools.ietf.org/html/rfc8624#section-3.1).
     */
    public val signingAlgorithmMnemonic: Output<String>
        get() = javaResource.signingAlgorithmMnemonic().applyValue({ args0 -> args0 })

    /**
     * An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3&#46;1](https://tools.ietf.org/html/rfc8624#section-3.1).
     */
    public val signingAlgorithmType: Output<Int>
        get() = javaResource.signingAlgorithmType().applyValue({ args0 -> args0 })

    /**
     * Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object KeySigningKeyMapper : ResourceMapper<KeySigningKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.KeySigningKey::class == javaResource::class

    override fun map(javaResource: Resource): KeySigningKey = KeySigningKey(
        javaResource as
            com.pulumi.aws.route53.KeySigningKey,
    )
}

/**
 * @see [KeySigningKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeySigningKey].
 */
public suspend fun keySigningKey(
    name: String,
    block: suspend KeySigningKeyResourceBuilder.() -> Unit,
): KeySigningKey {
    val builder = KeySigningKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeySigningKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keySigningKey(name: String): KeySigningKey {
    val builder = KeySigningKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
