@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.KeySigningKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Route 53 Key Signing Key. To manage Domain Name System Security Extensions (DNSSEC) for a Hosted Zone, see the `aws.route53.HostedZoneDnsSec` resource. For more information about managing DNSSEC in Route 53, see the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.KeySigningKey;
 * import com.pulumi.aws.route53.KeySigningKeyArgs;
 * import com.pulumi.aws.route53.HostedZoneDnsSec;
 * import com.pulumi.aws.route53.HostedZoneDnsSecArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .customerMasterKeySpec("ECC_NIST_P256")
 *             .deletionWindowInDays(7)
 *             .keyUsage("SIGN_VERIFY")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Action", jsonArray(
 *                                 "kms:DescribeKey",
 *                                 "kms:GetPublicKey",
 *                                 "kms:Sign"
 *                             )),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "dnssec-route53.amazonaws.com")
 *                             )),
 *                             jsonProperty("Sid", "Allow Route 53 DNSSEC Service"),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Condition", jsonObject(
 *                                 jsonProperty("StringEquals", jsonObject(
 *                                     jsonProperty("aws:SourceAccount", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                                 )),
 *                                 jsonProperty("ArnLike", jsonObject(
 *                                     jsonProperty("aws:SourceArn", "arn:aws:route53:::hostedzone/*")
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", "kms:CreateGrant"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("Service", "dnssec-route53.amazonaws.com")
 *                             )),
 *                             jsonProperty("Sid", "Allow Route 53 DNSSEC Service to CreateGrant"),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Condition", jsonObject(
 *                                 jsonProperty("Bool", jsonObject(
 *                                     jsonProperty("kms:GrantIsForAWSResource", "true")
 *                                 ))
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Action", "kms:*"),
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Principal", jsonObject(
 *                                 jsonProperty("AWS", String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                             )),
 *                             jsonProperty("Resource", "*"),
 *                             jsonProperty("Sid", "Enable IAM User Permissions")
 *                         )
 *                     )),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var exampleZone = new Zone("exampleZone");
 *         var exampleKeySigningKey = new KeySigningKey("exampleKeySigningKey", KeySigningKeyArgs.builder()
 *             .hostedZoneId(aws_route53_zone.test().id())
 *             .keyManagementServiceArn(aws_kms_key.test().arn())
 *             .build());
 *         var exampleHostedZoneDnsSec = new HostedZoneDnsSec("exampleHostedZoneDnsSec", HostedZoneDnsSecArgs.builder()
 *             .hostedZoneId(exampleKeySigningKey.hostedZoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleKeySigningKey)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_route53_key_signing_key` resources using the Route 53 Hosted Zone identifier and KMS Key identifier, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:route53/keySigningKey:KeySigningKey example Z1D633PJN98FT9,example
 * ```
 * @property hostedZoneId Identifier of the Route 53 Hosted Zone.
 * @property keyManagementServiceArn Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements&#46;html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
 * @property name Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
 * The following arguments are optional:
 * @property status Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
 * */
 */
public data class KeySigningKeyArgs(
    public val hostedZoneId: Output<String>? = null,
    public val keyManagementServiceArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.KeySigningKeyArgs> {
    override fun toJava(): com.pulumi.aws.route53.KeySigningKeyArgs =
        com.pulumi.aws.route53.KeySigningKeyArgs.builder()
            .hostedZoneId(hostedZoneId?.applyValue({ args0 -> args0 }))
            .keyManagementServiceArn(keyManagementServiceArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeySigningKeyArgs].
 */
@PulumiTagMarker
public class KeySigningKeyArgsBuilder internal constructor() {
    private var hostedZoneId: Output<String>? = null

    private var keyManagementServiceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Identifier of the Route 53 Hosted Zone.
     */
    @JvmName("ucsqymcuxmorhbjm")
    public suspend fun hostedZoneId(`value`: Output<String>) {
        this.hostedZoneId = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements&#46;html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
     */
    @JvmName("qndplxdhbflbaelw")
    public suspend fun keyManagementServiceArn(`value`: Output<String>) {
        this.keyManagementServiceArn = value
    }

    /**
     * @param value Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
     * The following arguments are optional:
     */
    @JvmName("dkipklkxsbutkwqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
     */
    @JvmName("knjtouxoncixscwn")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Identifier of the Route 53 Hosted Zone.
     */
    @JvmName("qkqwrurrbwonumli")
    public suspend fun hostedZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedZoneId = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs&#46;aws&#46;amazon&#46;com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements&#46;html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
     */
    @JvmName("nlrsuwuuvroqecoi")
    public suspend fun keyManagementServiceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyManagementServiceArn = mapped
    }

    /**
     * @param value Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
     * The following arguments are optional:
     */
    @JvmName("vfoytynnafwlqqku")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
     */
    @JvmName("owwcplgsbhxegnqb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): KeySigningKeyArgs = KeySigningKeyArgs(
        hostedZoneId = hostedZoneId,
        keyManagementServiceArn = keyManagementServiceArn,
        name = name,
        status = status,
    )
}
