@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [QueryLog].
 */
@PulumiTagMarker
public class QueryLogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueryLogArgs = QueryLogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueryLogArgsBuilder.() -> Unit) {
        val builder = QueryLogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): QueryLog {
        val builtJavaResource = com.pulumi.aws.route53.QueryLog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QueryLog(builtJavaResource)
    }
}

/**
 * Provides a Route53 query logging configuration resource.
 * > **NOTE:** There are restrictions on the configuration of query logging. Notably,
 * the CloudWatch log group must be in the `us-east-1` region,
 * a permissive CloudWatch log resource policy must be in place, and
 * the Route53 hosted zone must be public.
 * See [Configuring Logging for DNS Queries](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html?console_help=true#query-logs-configuring) for additional details.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.QueryLog;
 * import com.pulumi.aws.route53.QueryLogArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var us_east_1 = new Provider("us-east-1", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var awsRoute53ExampleCom = new LogGroup("awsRoute53ExampleCom", LogGroupArgs.builder()
 *             .retentionInDays(30)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .build());
 *         final var route53-query-logging-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .resources("arn:aws:logs:*:*:log-group:/aws/route53/*")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("route53.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var route53_query_logging_policyLogResourcePolicy = new LogResourcePolicy("route53-query-logging-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(route53_query_logging_policyPolicyDocument.json())
 *             .policyName("route53-query-logging-policy")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .build());
 *         var exampleComZone = new Zone("exampleComZone");
 *         var exampleComQueryLog = new QueryLog("exampleComQueryLog", QueryLogArgs.builder()
 *             .cloudwatchLogGroupArn(awsRoute53ExampleCom.arn())
 *             .zoneId(exampleComZone.zoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(route53_query_logging_policyLogResourcePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 query logging configurations using their ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/queryLog:QueryLog example_com xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 * */
 */
public class QueryLog internal constructor(
    override val javaResource: com.pulumi.aws.route53.QueryLog,
) : KotlinCustomResource(javaResource, QueryLogMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Query Logging Config.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * CloudWatch log group ARN to send query logs.
     */
    public val cloudwatchLogGroupArn: Output<String>
        get() = javaResource.cloudwatchLogGroupArn().applyValue({ args0 -> args0 })

    /**
     * Route53 hosted zone ID to enable query logs.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object QueryLogMapper : ResourceMapper<QueryLog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.QueryLog::class == javaResource::class

    override fun map(javaResource: Resource): QueryLog = QueryLog(
        javaResource as
            com.pulumi.aws.route53.QueryLog,
    )
}

/**
 * @see [QueryLog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QueryLog].
 */
public suspend fun queryLog(name: String, block: suspend QueryLogResourceBuilder.() -> Unit):
    QueryLog {
    val builder = QueryLogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QueryLog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queryLog(name: String): QueryLog {
    val builder = QueryLogResourceBuilder()
    builder.name(name)
    return builder.build()
}
