@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.QueryLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route53 query logging configuration resource.
 * > **NOTE:** There are restrictions on the configuration of query logging. Notably,
 * the CloudWatch log group must be in the `us-east-1` region,
 * a permissive CloudWatch log resource policy must be in place, and
 * the Route53 hosted zone must be public.
 * See [Configuring Logging for DNS Queries](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html?console_help=true#query-logs-configuring) for additional details.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.QueryLog;
 * import com.pulumi.aws.route53.QueryLogArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var us_east_1 = new Provider("us-east-1", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var awsRoute53ExampleCom = new LogGroup("awsRoute53ExampleCom", LogGroupArgs.builder()
 *             .retentionInDays(30)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .build());
 *         final var route53-query-logging-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .resources("arn:aws:logs:*:*:log-group:/aws/route53/*")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("route53.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var route53_query_logging_policyLogResourcePolicy = new LogResourcePolicy("route53-query-logging-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(route53_query_logging_policyPolicyDocument.json())
 *             .policyName("route53-query-logging-policy")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.us-east-1())
 *                 .build());
 *         var exampleComZone = new Zone("exampleComZone");
 *         var exampleComQueryLog = new QueryLog("exampleComQueryLog", QueryLogArgs.builder()
 *             .cloudwatchLogGroupArn(awsRoute53ExampleCom.arn())
 *             .zoneId(exampleComZone.zoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(route53_query_logging_policyLogResourcePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 query logging configurations using their ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/queryLog:QueryLog example_com xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx
 * ```
 * @property cloudwatchLogGroupArn CloudWatch log group ARN to send query logs.
 * @property zoneId Route53 hosted zone ID to enable query logs.
 * */
 */
public data class QueryLogArgs(
    public val cloudwatchLogGroupArn: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.QueryLogArgs> {
    override fun toJava(): com.pulumi.aws.route53.QueryLogArgs =
        com.pulumi.aws.route53.QueryLogArgs.builder()
            .cloudwatchLogGroupArn(cloudwatchLogGroupArn?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueryLogArgs].
 */
@PulumiTagMarker
public class QueryLogArgsBuilder internal constructor() {
    private var cloudwatchLogGroupArn: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value CloudWatch log group ARN to send query logs.
     */
    @JvmName("gyfdcjwqhfybltjc")
    public suspend fun cloudwatchLogGroupArn(`value`: Output<String>) {
        this.cloudwatchLogGroupArn = value
    }

    /**
     * @param value Route53 hosted zone ID to enable query logs.
     */
    @JvmName("noivnxpbngjoxwwg")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value CloudWatch log group ARN to send query logs.
     */
    @JvmName("yhmadmnuxkxfmcyr")
    public suspend fun cloudwatchLogGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogGroupArn = mapped
    }

    /**
     * @param value Route53 hosted zone ID to enable query logs.
     */
    @JvmName("ouxpoyfyqtcskdkf")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): QueryLogArgs = QueryLogArgs(
        cloudwatchLogGroupArn = cloudwatchLogGroupArn,
        zoneId = zoneId,
    )
}
