@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.RecordArgs.builder
import com.pulumi.aws.route53.kotlin.enums.RecordType
import com.pulumi.aws.route53.kotlin.inputs.RecordAliasArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordAliasArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordCidrRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordCidrRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordFailoverRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordFailoverRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordGeolocationRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordGeolocationRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordLatencyRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordLatencyRoutingPolicyArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.RecordWeightedRoutingPolicyArgs
import com.pulumi.aws.route53.kotlin.inputs.RecordWeightedRoutingPolicyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Route53 record resource.
 * ## Example Usage
 * ### Simple routing policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.primary().zone_id())
 *             .name("www.example.com")
 *             .type("A")
 *             .ttl(300)
 *             .records(aws_eip.lb().public_ip())
 *             .build());
 *     }
 * }
 * ```
 * ### Weighted routing policy
 * Other routing policies are configured similarly. See [Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html) for details.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var www_dev = new Record("www-dev", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.primary().zone_id())
 *             .name("www")
 *             .type("CNAME")
 *             .ttl(5)
 *             .weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs.builder()
 *                 .weight(10)
 *                 .build())
 *             .setIdentifier("dev")
 *             .records("dev.example.com")
 *             .build());
 *         var www_live = new Record("www-live", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.primary().zone_id())
 *             .name("www")
 *             .type("CNAME")
 *             .ttl(5)
 *             .weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs.builder()
 *                 .weight(90)
 *                 .build())
 *             .setIdentifier("live")
 *             .records("live.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### Alias record
 * See [related part of Amazon Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/resource-record-sets-choosing-alias-non-alias.html)
 * to understand differences between alias and non-alias records.
 * TTL for all alias records is [60 seconds](https://aws.amazon.com/route53/faqs/#dns_failover_do_i_need_to_adjust),
 * you cannot change this, therefore `ttl` has to be omitted in alias records.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new LoadBalancer("main", LoadBalancerArgs.builder()
 *             .availabilityZones("us-east-1c")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(80)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var www = new Record("www", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.primary().zone_id())
 *             .name("example.com")
 *             .type("A")
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(main.dnsName())
 *                 .zoneId(main.zoneId())
 *                 .evaluateTargetHealth(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### NS and SOA Record Management
 * When creating Route 53 zones, the `NS` and `SOA` records for the zone are automatically created. Enabling the `allow_overwrite` argument will allow managing these records in a single deployment without the requirement for `import`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleZone = new Zone("exampleZone");
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .allowOverwrite(true)
 *             .name("test.example.com")
 *             .ttl(172800)
 *             .type("NS")
 *             .zoneId(exampleZone.zoneId())
 *             .records(
 *                 exampleZone.nameServers().applyValue(nameServers -> nameServers[0]),
 *                 exampleZone.nameServers().applyValue(nameServers -> nameServers[1]),
 *                 exampleZone.nameServers().applyValue(nameServers -> nameServers[2]),
 *                 exampleZone.nameServers().applyValue(nameServers -> nameServers[3]))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * If the record also contains a set identifier, append it:
 * If the record name is the empty string, it can be omitted:
 * __Using `pulumi import` to import__ Route53 Records using the ID of the record, record name, record type, and set identifier. For example:
 * Using the ID of the record, which is the zone identifier, record name, and record type, separated by underscores (`_`):
 * ```sh
 *  $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS
 * ```
 *  If the record also contains a set identifier, append it:
 * ```sh
 *  $ pulumi import aws:route53/record:Record myrecord Z4KAPRWWNC7JR_dev.example.com_NS_dev
 * ```
 * @property aliases An alias block. Conflicts with `ttl` & `records`.
 * Documented below.
 * @property allowOverwrite Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
 * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
 * @property cidrRoutingPolicy A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
 * @property failoverRoutingPolicies A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
 * @property geolocationRoutingPolicies A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
 * @property healthCheckId The health check the record should be associated with.
 * @property latencyRoutingPolicies A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
 * @property multivalueAnswerRoutingPolicy Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
 * @property name The name of the record.
 * @property records A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
 * @property setIdentifier Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
 * @property ttl The TTL of the record.
 * @property type The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
 * @property weightedRoutingPolicies A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
 * @property zoneId The ID of the hosted zone to contain this record.
 */
public data class RecordArgs(
    public val aliases: Output<List<RecordAliasArgs>>? = null,
    public val allowOverwrite: Output<Boolean>? = null,
    public val cidrRoutingPolicy: Output<RecordCidrRoutingPolicyArgs>? = null,
    public val failoverRoutingPolicies: Output<List<RecordFailoverRoutingPolicyArgs>>? = null,
    public val geolocationRoutingPolicies: Output<List<RecordGeolocationRoutingPolicyArgs>>? = null,
    public val healthCheckId: Output<String>? = null,
    public val latencyRoutingPolicies: Output<List<RecordLatencyRoutingPolicyArgs>>? = null,
    public val multivalueAnswerRoutingPolicy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val records: Output<List<String>>? = null,
    public val setIdentifier: Output<String>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<Either<String, RecordType>>? = null,
    public val weightedRoutingPolicies: Output<List<RecordWeightedRoutingPolicyArgs>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.RecordArgs> {
    override fun toJava(): com.pulumi.aws.route53.RecordArgs =
        com.pulumi.aws.route53.RecordArgs.builder()
            .aliases(
                aliases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .allowOverwrite(allowOverwrite?.applyValue({ args0 -> args0 }))
            .cidrRoutingPolicy(cidrRoutingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failoverRoutingPolicies(
                failoverRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .geolocationRoutingPolicies(
                geolocationRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .healthCheckId(healthCheckId?.applyValue({ args0 -> args0 }))
            .latencyRoutingPolicies(
                latencyRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .multivalueAnswerRoutingPolicy(multivalueAnswerRoutingPolicy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .records(records?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .setIdentifier(setIdentifier?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .weightedRoutingPolicies(
                weightedRoutingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordArgs].
 */
@PulumiTagMarker
public class RecordArgsBuilder internal constructor() {
    private var aliases: Output<List<RecordAliasArgs>>? = null

    private var allowOverwrite: Output<Boolean>? = null

    private var cidrRoutingPolicy: Output<RecordCidrRoutingPolicyArgs>? = null

    private var failoverRoutingPolicies: Output<List<RecordFailoverRoutingPolicyArgs>>? = null

    private var geolocationRoutingPolicies: Output<List<RecordGeolocationRoutingPolicyArgs>>? = null

    private var healthCheckId: Output<String>? = null

    private var latencyRoutingPolicies: Output<List<RecordLatencyRoutingPolicyArgs>>? = null

    private var multivalueAnswerRoutingPolicy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var records: Output<List<String>>? = null

    private var setIdentifier: Output<String>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<Either<String, RecordType>>? = null

    private var weightedRoutingPolicies: Output<List<RecordWeightedRoutingPolicyArgs>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("gkohcseujhcgayro")
    public suspend fun aliases(`value`: Output<List<RecordAliasArgs>>) {
        this.aliases = value
    }

    @JvmName("mgpcjelkufnntmox")
    public suspend fun aliases(vararg values: Output<RecordAliasArgs>) {
        this.aliases = Output.all(values.asList())
    }

    /**
     * @param values An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("xcoxercncfiobcxp")
    public suspend fun aliases(values: List<Output<RecordAliasArgs>>) {
        this.aliases = Output.all(values)
    }

    /**
     * @param value Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
     */
    @JvmName("wisjdfnjtkfiwwte")
    public suspend fun allowOverwrite(`value`: Output<Boolean>) {
        this.allowOverwrite = value
    }

    /**
     * @param value A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("njpmdwoddfkotium")
    public suspend fun cidrRoutingPolicy(`value`: Output<RecordCidrRoutingPolicyArgs>) {
        this.cidrRoutingPolicy = value
    }

    /**
     * @param value A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("fqcdxpamffyvvnas")
    public suspend
    fun failoverRoutingPolicies(`value`: Output<List<RecordFailoverRoutingPolicyArgs>>) {
        this.failoverRoutingPolicies = value
    }

    @JvmName("xaoqspvhdcyifdvk")
    public suspend fun failoverRoutingPolicies(
        vararg
        values: Output<RecordFailoverRoutingPolicyArgs>,
    ) {
        this.failoverRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("snqvmobqynjgbtas")
    public suspend
    fun failoverRoutingPolicies(values: List<Output<RecordFailoverRoutingPolicyArgs>>) {
        this.failoverRoutingPolicies = Output.all(values)
    }

    /**
     * @param value A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("grnlrfojraimhins")
    public suspend
    fun geolocationRoutingPolicies(`value`: Output<List<RecordGeolocationRoutingPolicyArgs>>) {
        this.geolocationRoutingPolicies = value
    }

    @JvmName("lsnkheukhnrrcxee")
    public suspend fun geolocationRoutingPolicies(
        vararg
        values: Output<RecordGeolocationRoutingPolicyArgs>,
    ) {
        this.geolocationRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("abocnpyfunbapgyr")
    public suspend
    fun geolocationRoutingPolicies(values: List<Output<RecordGeolocationRoutingPolicyArgs>>) {
        this.geolocationRoutingPolicies = Output.all(values)
    }

    /**
     * @param value The health check the record should be associated with.
     */
    @JvmName("wifxilcaahhwwgsm")
    public suspend fun healthCheckId(`value`: Output<String>) {
        this.healthCheckId = value
    }

    /**
     * @param value A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("bnhasskebbpqmrpk")
    public suspend fun latencyRoutingPolicies(`value`: Output<List<RecordLatencyRoutingPolicyArgs>>) {
        this.latencyRoutingPolicies = value
    }

    @JvmName("dpsyngaeghmfpyvi")
    public suspend fun latencyRoutingPolicies(vararg values: Output<RecordLatencyRoutingPolicyArgs>) {
        this.latencyRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("mmnlobqffyirkhqn")
    public suspend fun latencyRoutingPolicies(values: List<Output<RecordLatencyRoutingPolicyArgs>>) {
        this.latencyRoutingPolicies = Output.all(values)
    }

    /**
     * @param value Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     */
    @JvmName("cdkgadbrkspwcsxu")
    public suspend fun multivalueAnswerRoutingPolicy(`value`: Output<Boolean>) {
        this.multivalueAnswerRoutingPolicy = value
    }

    /**
     * @param value The name of the record.
     */
    @JvmName("xjvmuphreswgblyd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("uqalhdggwlgxsdlp")
    public suspend fun records(`value`: Output<List<String>>) {
        this.records = value
    }

    @JvmName("qdphcicfqeeryadt")
    public suspend fun records(vararg values: Output<String>) {
        this.records = Output.all(values.asList())
    }

    /**
     * @param values A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("wbhfoplkbawkqtqk")
    public suspend fun records(values: List<Output<String>>) {
        this.records = Output.all(values)
    }

    /**
     * @param value Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     */
    @JvmName("tlscpehbchayklux")
    public suspend fun setIdentifier(`value`: Output<String>) {
        this.setIdentifier = value
    }

    /**
     * @param value The TTL of the record.
     */
    @JvmName("btjrqpnqkeqnyqhq")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("uotveoxysywdfism")
    public suspend fun type(`value`: Output<Either<String, RecordType>>) {
        this.type = value
    }

    /**
     * @param value A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("wowpyhgtmesuamfu")
    public suspend
    fun weightedRoutingPolicies(`value`: Output<List<RecordWeightedRoutingPolicyArgs>>) {
        this.weightedRoutingPolicies = value
    }

    @JvmName("ebimoxnkcowcpfxv")
    public suspend fun weightedRoutingPolicies(
        vararg
        values: Output<RecordWeightedRoutingPolicyArgs>,
    ) {
        this.weightedRoutingPolicies = Output.all(values.asList())
    }

    /**
     * @param values A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("xcducsiepikgnwbw")
    public suspend
    fun weightedRoutingPolicies(values: List<Output<RecordWeightedRoutingPolicyArgs>>) {
        this.weightedRoutingPolicies = Output.all(values)
    }

    /**
     * @param value The ID of the hosted zone to contain this record.
     */
    @JvmName("ppjhrnjvrdlhwlik")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("gicfvnhikpenjtud")
    public suspend fun aliases(`value`: List<RecordAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param argument An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("qbkmntkqvddujpow")
    public suspend fun aliases(argument: List<suspend RecordAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RecordAliasArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param argument An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("ocfaxtpthmabqlpe")
    public suspend fun aliases(vararg argument: suspend RecordAliasArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RecordAliasArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param argument An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("jedxpidyqeyyikii")
    public suspend fun aliases(argument: suspend RecordAliasArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecordAliasArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param values An alias block. Conflicts with `ttl` & `records`.
     * Documented below.
     */
    @JvmName("bdcfehfqlxwaqlgd")
    public suspend fun aliases(vararg values: RecordAliasArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param value Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * Exactly one of `records` or `alias` must be specified: this determines whether it's an alias record.
     */
    @JvmName("dgsfqpgouvlfndkf")
    public suspend fun allowOverwrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowOverwrite = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("xukmechqxjeeiiui")
    public suspend fun cidrRoutingPolicy(`value`: RecordCidrRoutingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrRoutingPolicy = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("ervobnwcejgrharx")
    public suspend
    fun cidrRoutingPolicy(argument: suspend RecordCidrRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RecordCidrRoutingPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cidrRoutingPolicy = mapped
    }

    /**
     * @param value A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("pstgsouftavvcwvf")
    public suspend fun failoverRoutingPolicies(`value`: List<RecordFailoverRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("nvchokcltofwtbuk")
    public suspend
    fun failoverRoutingPolicies(argument: List<suspend RecordFailoverRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordFailoverRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("puispyyxirhycebi")
    public suspend fun failoverRoutingPolicies(
        vararg
        argument: suspend RecordFailoverRoutingPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecordFailoverRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("pmsxhpcirowqqsxc")
    public suspend
    fun failoverRoutingPolicies(argument: suspend RecordFailoverRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordFailoverRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("tmesdetkuhxkhjqf")
    public suspend fun failoverRoutingPolicies(vararg values: RecordFailoverRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverRoutingPolicies = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("xasplkwydpqvclgc")
    public suspend
    fun geolocationRoutingPolicies(`value`: List<RecordGeolocationRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("gtnoohcmyrbybqyd")
    public suspend
    fun geolocationRoutingPolicies(argument: List<suspend RecordGeolocationRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordGeolocationRoutingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("iiwvsyeenhvgvpmp")
    public suspend fun geolocationRoutingPolicies(
        vararg
        argument: suspend RecordGeolocationRoutingPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecordGeolocationRoutingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("vukdblsliqmthqku")
    public suspend
    fun geolocationRoutingPolicies(argument: suspend RecordGeolocationRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordGeolocationRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("xwqedncnuatouilq")
    public suspend fun geolocationRoutingPolicies(vararg values: RecordGeolocationRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geolocationRoutingPolicies = mapped
    }

    /**
     * @param value The health check the record should be associated with.
     */
    @JvmName("qvffsawlafqqjtgk")
    public suspend fun healthCheckId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckId = mapped
    }

    /**
     * @param value A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("nrhdfldfpmcycssp")
    public suspend fun latencyRoutingPolicies(`value`: List<RecordLatencyRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("otshukaqcmtkprvs")
    public suspend
    fun latencyRoutingPolicies(argument: List<suspend RecordLatencyRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordLatencyRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("ebhhhisqownerghy")
    public suspend fun latencyRoutingPolicies(
        vararg
        argument: suspend RecordLatencyRoutingPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecordLatencyRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("thhvocogauuukase")
    public suspend
    fun latencyRoutingPolicies(argument: suspend RecordLatencyRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordLatencyRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("ikjxbftvekeglnle")
    public suspend fun latencyRoutingPolicies(vararg values: RecordLatencyRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.latencyRoutingPolicies = mapped
    }

    /**
     * @param value Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     */
    @JvmName("cmnltjnoummmkmoo")
    public suspend fun multivalueAnswerRoutingPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multivalueAnswerRoutingPolicy = mapped
    }

    /**
     * @param value The name of the record.
     */
    @JvmName("scsmnnrrgmostwbi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("eroyvtvlgikhweel")
    public suspend fun records(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.records = mapped
    }

    /**
     * @param values A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\"\"` inside the provider configuration string (e.g., `"first255characters\"\"morecharacters"`).
     */
    @JvmName("tpncymmfofubhgxb")
    public suspend fun records(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.records = mapped
    }

    /**
     * @param value Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     */
    @JvmName("rnutjghhmjhvqkyg")
    public suspend fun setIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.setIdentifier = mapped
    }

    /**
     * @param value The TTL of the record.
     */
    @JvmName("jtdmajuvupqulfej")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("pwidickrsqpfkape")
    public suspend fun type(`value`: Either<String, RecordType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("omhogokglbtnungy")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecordType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     */
    @JvmName("fgnyjklvmelkksgg")
    public fun type(`value`: RecordType) {
        val toBeMapped = Either.ofRight<String, RecordType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("pdnujitudxujhlip")
    public suspend fun weightedRoutingPolicies(`value`: List<RecordWeightedRoutingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("juvsgcyrnjqpsjcp")
    public suspend
    fun weightedRoutingPolicies(argument: List<suspend RecordWeightedRoutingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecordWeightedRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("gvxcdsijwtrhnsep")
    public suspend fun weightedRoutingPolicies(
        vararg
        argument: suspend RecordWeightedRoutingPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecordWeightedRoutingPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param argument A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("usbbjaxjjfmnkpbq")
    public suspend
    fun weightedRoutingPolicies(argument: suspend RecordWeightedRoutingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecordWeightedRoutingPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param values A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     */
    @JvmName("cmqdskuhsapnrxuh")
    public suspend fun weightedRoutingPolicies(vararg values: RecordWeightedRoutingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weightedRoutingPolicies = mapped
    }

    /**
     * @param value The ID of the hosted zone to contain this record.
     */
    @JvmName("hditpfganoacaefg")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): RecordArgs = RecordArgs(
        aliases = aliases,
        allowOverwrite = allowOverwrite,
        cidrRoutingPolicy = cidrRoutingPolicy,
        failoverRoutingPolicies = failoverRoutingPolicies,
        geolocationRoutingPolicies = geolocationRoutingPolicies,
        healthCheckId = healthCheckId,
        latencyRoutingPolicies = latencyRoutingPolicies,
        multivalueAnswerRoutingPolicy = multivalueAnswerRoutingPolicy,
        name = name,
        records = records,
        setIdentifier = setIdentifier,
        ttl = ttl,
        type = type,
        weightedRoutingPolicies = weightedRoutingPolicies,
        zoneId = zoneId,
    )
}
