@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResolverConfig].
 */
@PulumiTagMarker
public class ResolverConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverConfigArgs = ResolverConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverConfigArgsBuilder.() -> Unit) {
        val builder = ResolverConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverConfig {
        val builtJavaResource = com.pulumi.aws.route53.ResolverConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverConfig(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver config resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.ResolverConfig;
 * import com.pulumi.aws.route53.ResolverConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var exampleResolverConfig = new ResolverConfig("exampleResolverConfig", ResolverConfigArgs.builder()
 *             .resourceId(exampleVpc.id())
 *             .autodefinedReverseFlag("DISABLE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route 53 Resolver configs using the Route 53 Resolver config ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverConfig:ResolverConfig example rslvr-rc-715aa20c73a23da7
 * ```
 *
 */
public class ResolverConfig internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverConfig,
) : KotlinCustomResource(javaResource, ResolverConfigMapper) {
    /**
     * Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. Valid values: `ENABLE`, `DISABLE`.
     */
    public val autodefinedReverseFlag: Output<String>
        get() = javaResource.autodefinedReverseFlag().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the owner of the VPC that this resolver configuration applies to.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC that the configuration is for.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })
}

public object ResolverConfigMapper : ResourceMapper<ResolverConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverConfig::class == javaResource::class

    override fun map(javaResource: Resource): ResolverConfig = ResolverConfig(
        javaResource as
            com.pulumi.aws.route53.ResolverConfig,
    )
}

/**
 * @see [ResolverConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverConfig].
 */
public suspend fun resolverConfig(
    name: String,
    block: suspend ResolverConfigResourceBuilder.() -> Unit,
): ResolverConfig {
    val builder = ResolverConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverConfig(name: String): ResolverConfig {
    val builder = ResolverConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
