@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver config resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.ResolverConfig;
 * import com.pulumi.aws.route53.ResolverConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var exampleResolverConfig = new ResolverConfig("exampleResolverConfig", ResolverConfigArgs.builder()
 *             .resourceId(exampleVpc.id())
 *             .autodefinedReverseFlag("DISABLE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route 53 Resolver configs using the Route 53 Resolver config ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverConfig:ResolverConfig example rslvr-rc-715aa20c73a23da7
 * ```
 * @property autodefinedReverseFlag Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. Valid values: `ENABLE`, `DISABLE`.
 * @property resourceId The ID of the VPC that the configuration is for.
 */
public data class ResolverConfigArgs(
    public val autodefinedReverseFlag: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverConfigArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverConfigArgs =
        com.pulumi.aws.route53.ResolverConfigArgs.builder()
            .autodefinedReverseFlag(autodefinedReverseFlag?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverConfigArgs].
 */
@PulumiTagMarker
public class ResolverConfigArgsBuilder internal constructor() {
    private var autodefinedReverseFlag: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. Valid values: `ENABLE`, `DISABLE`.
     */
    @JvmName("ubgigmnugoswtfsy")
    public suspend fun autodefinedReverseFlag(`value`: Output<String>) {
        this.autodefinedReverseFlag = value
    }

    /**
     * @param value The ID of the VPC that the configuration is for.
     */
    @JvmName("mlvxkuwgnvwufvrh")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. Valid values: `ENABLE`, `DISABLE`.
     */
    @JvmName("qrbfsfjkrddtstmd")
    public suspend fun autodefinedReverseFlag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autodefinedReverseFlag = mapped
    }

    /**
     * @param value The ID of the VPC that the configuration is for.
     */
    @JvmName("oygmnlxrrrqxcjsd")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ResolverConfigArgs = ResolverConfigArgs(
        autodefinedReverseFlag = autodefinedReverseFlag,
        resourceId = resourceId,
    )
}
