@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverDnsSecConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver DNSSEC config resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.ResolverDnsSecConfig;
 * import com.pulumi.aws.route53.ResolverDnsSecConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var exampleResolverDnsSecConfig = new ResolverDnsSecConfig("exampleResolverDnsSecConfig", ResolverDnsSecConfigArgs.builder()
 *             .resourceId(exampleVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver DNSSEC configs using the Route 53 Resolver DNSSEC config ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverDnsSecConfig:ResolverDnsSecConfig example rdsc-be1866ecc1683e95
 * ```
 * @property resourceId The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
 */
public data class ResolverDnsSecConfigArgs(
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverDnsSecConfigArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverDnsSecConfigArgs =
        com.pulumi.aws.route53.ResolverDnsSecConfigArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverDnsSecConfigArgs].
 */
@PulumiTagMarker
public class ResolverDnsSecConfigArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
     */
    @JvmName("tmobmbstyefituoj")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
     */
    @JvmName("uqvsxhvhkqnwftsu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ResolverDnsSecConfigArgs = ResolverDnsSecConfigArgs(
        resourceId = resourceId,
    )
}
