@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.kotlin.outputs.ResolverEndpointIpAddress
import com.pulumi.aws.route53.kotlin.outputs.ResolverEndpointIpAddress.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ResolverEndpoint].
 */
@PulumiTagMarker
public class ResolverEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverEndpointArgs = ResolverEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverEndpointArgsBuilder.() -> Unit) {
        val builder = ResolverEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverEndpoint {
        val builtJavaResource = com.pulumi.aws.route53.ResolverEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverEndpoint(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver endpoint resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverEndpoint;
 * import com.pulumi.aws.route53.ResolverEndpointArgs;
 * import com.pulumi.aws.route53.inputs.ResolverEndpointIpAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ResolverEndpoint("foo", ResolverEndpointArgs.builder()
 *             .direction("INBOUND")
 *             .securityGroupIds(
 *                 aws_security_group.sg1().id(),
 *                 aws_security_group.sg2().id())
 *             .ipAddresses(
 *                 ResolverEndpointIpAddressArgs.builder()
 *                     .subnetId(aws_subnet.sn1().id())
 *                     .build(),
 *                 ResolverEndpointIpAddressArgs.builder()
 *                     .subnetId(aws_subnet.sn2().id())
 *                     .ip("10.0.64.4")
 *                     .build())
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver endpoints using the Route 53 Resolver endpoint ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverEndpoint:ResolverEndpoint foo rslvr-in-abcdef01234567890
 * ```
 *
 */
public class ResolverEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverEndpoint,
) : KotlinCustomResource(javaResource, ResolverEndpointMapper) {
    /**
     * The ARN of the Route 53 Resolver endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The direction of DNS queries to or from the Route 53 Resolver endpoint.
     * Valid values are `INBOUND` (resolver forwards DNS queries to the DNS service for a VPC from your network or another VPC)
     * or `OUTBOUND` (resolver forwards DNS queries from the DNS service for a VPC to your network or another VPC).
     */
    public val direction: Output<String>
        get() = javaResource.direction().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC that you want to create the resolver endpoint in.
     */
    public val hostVpcId: Output<String>
        get() = javaResource.hostVpcId().applyValue({ args0 -> args0 })

    /**
     * The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    public val ipAddresses: Output<List<ResolverEndpointIpAddress>>
        get() = javaResource.ipAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The friendly name of the Route 53 Resolver endpoint.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of one or more security groups that you want to use to control access to this VPC.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResolverEndpointMapper : ResourceMapper<ResolverEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ResolverEndpoint = ResolverEndpoint(
        javaResource as
            com.pulumi.aws.route53.ResolverEndpoint,
    )
}

/**
 * @see [ResolverEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverEndpoint].
 */
public suspend fun resolverEndpoint(
    name: String,
    block: suspend ResolverEndpointResourceBuilder.() -> Unit,
): ResolverEndpoint {
    val builder = ResolverEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverEndpoint(name: String): ResolverEndpoint {
    val builder = ResolverEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
