@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverEndpointArgs.builder
import com.pulumi.aws.route53.kotlin.inputs.ResolverEndpointIpAddressArgs
import com.pulumi.aws.route53.kotlin.inputs.ResolverEndpointIpAddressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver endpoint resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverEndpoint;
 * import com.pulumi.aws.route53.ResolverEndpointArgs;
 * import com.pulumi.aws.route53.inputs.ResolverEndpointIpAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ResolverEndpoint("foo", ResolverEndpointArgs.builder()
 *             .direction("INBOUND")
 *             .securityGroupIds(
 *                 aws_security_group.sg1().id(),
 *                 aws_security_group.sg2().id())
 *             .ipAddresses(
 *                 ResolverEndpointIpAddressArgs.builder()
 *                     .subnetId(aws_subnet.sn1().id())
 *                     .build(),
 *                 ResolverEndpointIpAddressArgs.builder()
 *                     .subnetId(aws_subnet.sn2().id())
 *                     .ip("10.0.64.4")
 *                     .build())
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver endpoints using the Route 53 Resolver endpoint ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverEndpoint:ResolverEndpoint foo rslvr-in-abcdef01234567890
 * ```
 * @property direction The direction of DNS queries to or from the Route 53 Resolver endpoint.
 * Valid values are `INBOUND` (resolver forwards DNS queries to the DNS service for a VPC from your network or another VPC)
 * or `OUTBOUND` (resolver forwards DNS queries from the DNS service for a VPC to your network or another VPC).
 * @property ipAddresses The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
 * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
 * @property name The friendly name of the Route 53 Resolver endpoint.
 * @property securityGroupIds The ID of one or more security groups that you want to use to control access to this VPC.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ResolverEndpointArgs(
    public val direction: Output<String>? = null,
    public val ipAddresses: Output<List<ResolverEndpointIpAddressArgs>>? = null,
    public val name: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverEndpointArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverEndpointArgs =
        com.pulumi.aws.route53.ResolverEndpointArgs.builder()
            .direction(direction?.applyValue({ args0 -> args0 }))
            .ipAddresses(
                ipAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResolverEndpointArgs].
 */
@PulumiTagMarker
public class ResolverEndpointArgsBuilder internal constructor() {
    private var direction: Output<String>? = null

    private var ipAddresses: Output<List<ResolverEndpointIpAddressArgs>>? = null

    private var name: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The direction of DNS queries to or from the Route 53 Resolver endpoint.
     * Valid values are `INBOUND` (resolver forwards DNS queries to the DNS service for a VPC from your network or another VPC)
     * or `OUTBOUND` (resolver forwards DNS queries from the DNS service for a VPC to your network or another VPC).
     */
    @JvmName("ykkynokbauosacrq")
    public suspend fun direction(`value`: Output<String>) {
        this.direction = value
    }

    /**
     * @param value The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("mebsvtpwswirquig")
    public suspend fun ipAddresses(`value`: Output<List<ResolverEndpointIpAddressArgs>>) {
        this.ipAddresses = value
    }

    @JvmName("todlnypogrmehxiv")
    public suspend fun ipAddresses(vararg values: Output<ResolverEndpointIpAddressArgs>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("ebfyekaqyxkysofu")
    public suspend fun ipAddresses(values: List<Output<ResolverEndpointIpAddressArgs>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value The friendly name of the Route 53 Resolver endpoint.
     */
    @JvmName("sdknhxqhgpwccted")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of one or more security groups that you want to use to control access to this VPC.
     */
    @JvmName("otdaxhssauqhtmsp")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("asnbowybecisnlmi")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of one or more security groups that you want to use to control access to this VPC.
     */
    @JvmName("hvnpoudkxrggetby")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iescwrvvajcjwslt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The direction of DNS queries to or from the Route 53 Resolver endpoint.
     * Valid values are `INBOUND` (resolver forwards DNS queries to the DNS service for a VPC from your network or another VPC)
     * or `OUTBOUND` (resolver forwards DNS queries from the DNS service for a VPC to your network or another VPC).
     */
    @JvmName("fodqyjervulibnpk")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("pntxxrqcenrhuida")
    public suspend fun ipAddresses(`value`: List<ResolverEndpointIpAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param argument The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("tyrpaoiihlousgxt")
    public suspend
    fun ipAddresses(argument: List<suspend ResolverEndpointIpAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResolverEndpointIpAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipAddresses = mapped
    }

    /**
     * @param argument The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("fwsmdipmnprwmjej")
    public suspend fun ipAddresses(
        vararg
        argument: suspend ResolverEndpointIpAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResolverEndpointIpAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipAddresses = mapped
    }

    /**
     * @param argument The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("rpghrhvbiyqiqbth")
    public suspend
    fun ipAddresses(argument: suspend ResolverEndpointIpAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResolverEndpointIpAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipAddresses = mapped
    }

    /**
     * @param values The subnets and IP addresses in your VPC that you want DNS queries to pass through on the way from your VPCs
     * to your network (for outbound endpoints) or on the way from your network to your VPCs (for inbound endpoints). Described below.
     */
    @JvmName("cicjqvbdbdsiaano")
    public suspend fun ipAddresses(vararg values: ResolverEndpointIpAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param value The friendly name of the Route 53 Resolver endpoint.
     */
    @JvmName("tcqfyjctcplhvgck")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of one or more security groups that you want to use to control access to this VPC.
     */
    @JvmName("swoofprtffkjxrso")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of one or more security groups that you want to use to control access to this VPC.
     */
    @JvmName("otkiikxffftsbrxd")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sexthnvaikbgbjdd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("thysirbufotsagnk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResolverEndpointArgs = ResolverEndpointArgs(
        direction = direction,
        ipAddresses = ipAddresses,
        name = name,
        securityGroupIds = securityGroupIds,
        tags = tags,
    )
}
