@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverFirewallDomainListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver DNS Firewall domain list resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallDomainList;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverFirewallDomainList("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver DNS Firewall domain lists using the Route 53 Resolver DNS Firewall domain list ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverFirewallDomainList:ResolverFirewallDomainList example rslvr-fdl-0123456789abcdef
 * ```
 * @property domains A array of domains for the firewall domain list.
 * @property name A name that lets you identify the domain list, to manage and use it.
 * @property tags A map of tags to assign to the resource. f configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ResolverFirewallDomainListArgs(
    public val domains: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverFirewallDomainListArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverFirewallDomainListArgs =
        com.pulumi.aws.route53.ResolverFirewallDomainListArgs.builder()
            .domains(domains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResolverFirewallDomainListArgs].
 */
@PulumiTagMarker
public class ResolverFirewallDomainListArgsBuilder internal constructor() {
    private var domains: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A array of domains for the firewall domain list.
     */
    @JvmName("plsyndxnwjyuodii")
    public suspend fun domains(`value`: Output<List<String>>) {
        this.domains = value
    }

    @JvmName("pnxejmjwyctqknvq")
    public suspend fun domains(vararg values: Output<String>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values A array of domains for the firewall domain list.
     */
    @JvmName("nlspcbymqbbyiflk")
    public suspend fun domains(values: List<Output<String>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value A name that lets you identify the domain list, to manage and use it.
     */
    @JvmName("hctlcialrkgrgthd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. f configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xugjkfiplpomybxd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A array of domains for the firewall domain list.
     */
    @JvmName("msjkvncnypialowb")
    public suspend fun domains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param values A array of domains for the firewall domain list.
     */
    @JvmName("bwoqtayldcqbkxck")
    public suspend fun domains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value A name that lets you identify the domain list, to manage and use it.
     */
    @JvmName("jyiyrgbgipkkytul")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. f configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ldvtorymbibhcfmb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. f configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yvglavsbcqwllvav")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResolverFirewallDomainListArgs = ResolverFirewallDomainListArgs(
        domains = domains,
        name = name,
        tags = tags,
    )
}
