@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResolverFirewallRule].
 */
@PulumiTagMarker
public class ResolverFirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverFirewallRuleArgs = ResolverFirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverFirewallRuleArgsBuilder.() -> Unit) {
        val builder = ResolverFirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverFirewallRule {
        val builtJavaResource = com.pulumi.aws.route53.ResolverFirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverFirewallRule(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver DNS Firewall rule resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallDomainList;
 * import com.pulumi.aws.route53.ResolverFirewallDomainListArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRule;
 * import com.pulumi.aws.route53.ResolverFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleResolverFirewallDomainList = new ResolverFirewallDomainList("exampleResolverFirewallDomainList", ResolverFirewallDomainListArgs.builder()
 *             .domains("example.com")
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRuleGroup = new ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup", ResolverFirewallRuleGroupArgs.builder()
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRule = new ResolverFirewallRule("exampleResolverFirewallRule", ResolverFirewallRuleArgs.builder()
 *             .action("BLOCK")
 *             .blockOverrideDnsType("CNAME")
 *             .blockOverrideDomain("example.com")
 *             .blockOverrideTtl(1)
 *             .blockResponse("OVERRIDE")
 *             .firewallDomainListId(exampleResolverFirewallDomainList.id())
 *             .firewallRuleGroupId(exampleResolverFirewallRuleGroup.id())
 *             .priority(100)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver DNS Firewall rules using the Route 53 Resolver DNS Firewall rule group ID and domain list ID separated by ':'. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverFirewallRule:ResolverFirewallRule example rslvr-frg-0123456789abcdef:rslvr-fdl-0123456789abcdef
 * ```
 *
 */
public class ResolverFirewallRule internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverFirewallRule,
) : KotlinCustomResource(javaResource, ResolverFirewallRuleMapper) {
    /**
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     */
    public val blockOverrideDnsType: Output<String>?
        get() = javaResource.blockOverrideDnsType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The custom DNS record to send back in response to the query.
     */
    public val blockOverrideDomain: Output<String>?
        get() = javaResource.blockOverrideDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     */
    public val blockOverrideTtl: Output<Int>?
        get() = javaResource.blockOverrideTtl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     */
    public val blockResponse: Output<String>?
        get() = javaResource.blockResponse().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the domain list that you want to use in the rule.
     */
    public val firewallDomainListId: Output<String>
        get() = javaResource.firewallDomainListId().applyValue({ args0 -> args0 })

    /**
     * The unique identifier of the firewall rule group where you want to create the rule.
     */
    public val firewallRuleGroupId: Output<String>
        get() = javaResource.firewallRuleGroupId().applyValue({ args0 -> args0 })

    /**
     * A name that lets you identify the rule, to manage and use it.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })
}

public object ResolverFirewallRuleMapper : ResourceMapper<ResolverFirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverFirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): ResolverFirewallRule = ResolverFirewallRule(
        javaResource
            as com.pulumi.aws.route53.ResolverFirewallRule,
    )
}

/**
 * @see [ResolverFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverFirewallRule].
 */
public suspend fun resolverFirewallRule(
    name: String,
    block: suspend ResolverFirewallRuleResourceBuilder.() -> Unit,
): ResolverFirewallRule {
    val builder = ResolverFirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverFirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverFirewallRule(name: String): ResolverFirewallRule {
    val builder = ResolverFirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
