@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverFirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver DNS Firewall rule resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallDomainList;
 * import com.pulumi.aws.route53.ResolverFirewallDomainListArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupArgs;
 * import com.pulumi.aws.route53.ResolverFirewallRule;
 * import com.pulumi.aws.route53.ResolverFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleResolverFirewallDomainList = new ResolverFirewallDomainList("exampleResolverFirewallDomainList", ResolverFirewallDomainListArgs.builder()
 *             .domains("example.com")
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRuleGroup = new ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup", ResolverFirewallRuleGroupArgs.builder()
 *             .tags()
 *             .build());
 *         var exampleResolverFirewallRule = new ResolverFirewallRule("exampleResolverFirewallRule", ResolverFirewallRuleArgs.builder()
 *             .action("BLOCK")
 *             .blockOverrideDnsType("CNAME")
 *             .blockOverrideDomain("example.com")
 *             .blockOverrideTtl(1)
 *             .blockResponse("OVERRIDE")
 *             .firewallDomainListId(exampleResolverFirewallDomainList.id())
 *             .firewallRuleGroupId(exampleResolverFirewallRuleGroup.id())
 *             .priority(100)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver DNS Firewall rules using the Route 53 Resolver DNS Firewall rule group ID and domain list ID separated by ':'. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverFirewallRule:ResolverFirewallRule example rslvr-frg-0123456789abcdef:rslvr-fdl-0123456789abcdef
 * ```
 * @property action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
 * @property blockOverrideDnsType The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
 * @property blockOverrideDomain The custom DNS record to send back in response to the query.
 * @property blockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
 * @property blockResponse The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
 * @property firewallDomainListId The ID of the domain list that you want to use in the rule.
 * @property firewallRuleGroupId The unique identifier of the firewall rule group where you want to create the rule.
 * @property name A name that lets you identify the rule, to manage and use it.
 * @property priority The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
 */
public data class ResolverFirewallRuleArgs(
    public val action: Output<String>? = null,
    public val blockOverrideDnsType: Output<String>? = null,
    public val blockOverrideDomain: Output<String>? = null,
    public val blockOverrideTtl: Output<Int>? = null,
    public val blockResponse: Output<String>? = null,
    public val firewallDomainListId: Output<String>? = null,
    public val firewallRuleGroupId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverFirewallRuleArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverFirewallRuleArgs =
        com.pulumi.aws.route53.ResolverFirewallRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .blockOverrideDnsType(blockOverrideDnsType?.applyValue({ args0 -> args0 }))
            .blockOverrideDomain(blockOverrideDomain?.applyValue({ args0 -> args0 }))
            .blockOverrideTtl(blockOverrideTtl?.applyValue({ args0 -> args0 }))
            .blockResponse(blockResponse?.applyValue({ args0 -> args0 }))
            .firewallDomainListId(firewallDomainListId?.applyValue({ args0 -> args0 }))
            .firewallRuleGroupId(firewallRuleGroupId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverFirewallRuleArgs].
 */
@PulumiTagMarker
public class ResolverFirewallRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var blockOverrideDnsType: Output<String>? = null

    private var blockOverrideDomain: Output<String>? = null

    private var blockOverrideTtl: Output<Int>? = null

    private var blockResponse: Output<String>? = null

    private var firewallDomainListId: Output<String>? = null

    private var firewallRuleGroupId: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     */
    @JvmName("txsdnonxlbqlkqmu")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     */
    @JvmName("qabxygcmelbxuwkb")
    public suspend fun blockOverrideDnsType(`value`: Output<String>) {
        this.blockOverrideDnsType = value
    }

    /**
     * @param value The custom DNS record to send back in response to the query.
     */
    @JvmName("ltsfdyysbqasxwwf")
    public suspend fun blockOverrideDomain(`value`: Output<String>) {
        this.blockOverrideDomain = value
    }

    /**
     * @param value The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     */
    @JvmName("vjktbhwfmhpondds")
    public suspend fun blockOverrideTtl(`value`: Output<Int>) {
        this.blockOverrideTtl = value
    }

    /**
     * @param value The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     */
    @JvmName("umppvoxntjqmgqng")
    public suspend fun blockResponse(`value`: Output<String>) {
        this.blockResponse = value
    }

    /**
     * @param value The ID of the domain list that you want to use in the rule.
     */
    @JvmName("ndpfekprfcknjcwj")
    public suspend fun firewallDomainListId(`value`: Output<String>) {
        this.firewallDomainListId = value
    }

    /**
     * @param value The unique identifier of the firewall rule group where you want to create the rule.
     */
    @JvmName("fbpvdqcaurdjmfvg")
    public suspend fun firewallRuleGroupId(`value`: Output<String>) {
        this.firewallRuleGroupId = value
    }

    /**
     * @param value A name that lets you identify the rule, to manage and use it.
     */
    @JvmName("eknabaxwdskgqwmw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    @JvmName("asdoxvesbkmjkeka")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     */
    @JvmName("jpiscqjtiobbkidk")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     */
    @JvmName("sqismnsisicklaho")
    public suspend fun blockOverrideDnsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockOverrideDnsType = mapped
    }

    /**
     * @param value The custom DNS record to send back in response to the query.
     */
    @JvmName("nudnmpusysnmbyfa")
    public suspend fun blockOverrideDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockOverrideDomain = mapped
    }

    /**
     * @param value The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     */
    @JvmName("hmisdryxoocpceib")
    public suspend fun blockOverrideTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockOverrideTtl = mapped
    }

    /**
     * @param value The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     */
    @JvmName("fnkefgtxuokcbres")
    public suspend fun blockResponse(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockResponse = mapped
    }

    /**
     * @param value The ID of the domain list that you want to use in the rule.
     */
    @JvmName("vxqikyoiheyrhbkq")
    public suspend fun firewallDomainListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallDomainListId = mapped
    }

    /**
     * @param value The unique identifier of the firewall rule group where you want to create the rule.
     */
    @JvmName("xjajxfffrmertdnw")
    public suspend fun firewallRuleGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleGroupId = mapped
    }

    /**
     * @param value A name that lets you identify the rule, to manage and use it.
     */
    @JvmName("xaneaubnulfjrojd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     */
    @JvmName("cxlkvhtyjdidjlxb")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): ResolverFirewallRuleArgs = ResolverFirewallRuleArgs(
        action = action,
        blockOverrideDnsType = blockOverrideDnsType,
        blockOverrideDomain = blockOverrideDomain,
        blockOverrideTtl = blockOverrideTtl,
        blockResponse = blockResponse,
        firewallDomainListId = firewallDomainListId,
        firewallRuleGroupId = firewallRuleGroupId,
        name = name,
        priority = priority,
    )
}
