@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResolverFirewallRuleGroup].
 */
@PulumiTagMarker
public class ResolverFirewallRuleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverFirewallRuleGroupArgs = ResolverFirewallRuleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverFirewallRuleGroupArgsBuilder.() -> Unit) {
        val builder = ResolverFirewallRuleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverFirewallRuleGroup {
        val builtJavaResource =
            com.pulumi.aws.route53.ResolverFirewallRuleGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResolverFirewallRuleGroup(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver DNS Firewall rule group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverFirewallRuleGroup("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver DNS Firewall rule groups using the Route 53 Resolver DNS Firewall rule group ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverFirewallRuleGroup:ResolverFirewallRuleGroup example rslvr-frg-0123456789abcdef
 * ```
 *
 */
public class ResolverFirewallRuleGroup internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverFirewallRuleGroup,
) : KotlinCustomResource(javaResource, ResolverFirewallRuleGroupMapper) {
    /**
     * The ARN (Amazon Resource Name) of the rule group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A name that lets you identify the rule group, to manage and use it.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID for the account that created the rule group. When a rule group is shared with your account, this is the account that has shared the rule group with you.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM). Valid values: `NOT_SHARED`, `SHARED_BY_ME`, `SHARED_WITH_ME`
     */
    public val shareStatus: Output<String>
        get() = javaResource.shareStatus().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResolverFirewallRuleGroupMapper : ResourceMapper<ResolverFirewallRuleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverFirewallRuleGroup::class == javaResource::class

    override fun map(javaResource: Resource): ResolverFirewallRuleGroup =
        ResolverFirewallRuleGroup(javaResource as com.pulumi.aws.route53.ResolverFirewallRuleGroup)
}

/**
 * @see [ResolverFirewallRuleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverFirewallRuleGroup].
 */
public suspend fun resolverFirewallRuleGroup(
    name: String,
    block: suspend ResolverFirewallRuleGroupResourceBuilder.() -> Unit,
): ResolverFirewallRuleGroup {
    val builder = ResolverFirewallRuleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverFirewallRuleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverFirewallRuleGroup(name: String): ResolverFirewallRuleGroup {
    val builder = ResolverFirewallRuleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
