@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResolverFirewallRuleGroupAssociation].
 */
@PulumiTagMarker
public class ResolverFirewallRuleGroupAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverFirewallRuleGroupAssociationArgs =
        ResolverFirewallRuleGroupAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ResolverFirewallRuleGroupAssociationArgsBuilder.() -> Unit) {
        val builder = ResolverFirewallRuleGroupAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverFirewallRuleGroupAssociation {
        val builtJavaResource =
            com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResolverFirewallRuleGroupAssociation(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver DNS Firewall rule group association resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociation;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleResolverFirewallRuleGroup = new ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup");
 *         var exampleResolverFirewallRuleGroupAssociation = new ResolverFirewallRuleGroupAssociation("exampleResolverFirewallRuleGroupAssociation", ResolverFirewallRuleGroupAssociationArgs.builder()
 *             .firewallRuleGroupId(exampleResolverFirewallRuleGroup.id())
 *             .priority(100)
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route 53 Resolver DNS Firewall rule group associations using the Route 53 Resolver DNS Firewall rule group association ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverFirewallRuleGroupAssociation:ResolverFirewallRuleGroupAssociation example rslvr-frgassoc-0123456789abcdef
 * ```
 *
 */
public class ResolverFirewallRuleGroupAssociation internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociation,
) : KotlinCustomResource(javaResource, ResolverFirewallRuleGroupAssociationMapper) {
    /**
     * The ARN (Amazon Resource Name) of the firewall rule group association.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The unique identifier of the firewall rule group.
     */
    public val firewallRuleGroupId: Output<String>
        get() = javaResource.firewallRuleGroupId().applyValue({ args0 -> args0 })

    /**
     * If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. Valid values: `ENABLED`, `DISABLED`.
     */
    public val mutationProtection: Output<String>
        get() = javaResource.mutationProtection().applyValue({ args0 -> args0 })

    /**
     * A name that lets you identify the rule group association, to manage and use it.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The unique identifier of the VPC that you want to associate with the rule group.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ResolverFirewallRuleGroupAssociationMapper :
    ResourceMapper<ResolverFirewallRuleGroupAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ResolverFirewallRuleGroupAssociation =
        ResolverFirewallRuleGroupAssociation(
            javaResource as
                com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociation,
        )
}

/**
 * @see [ResolverFirewallRuleGroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverFirewallRuleGroupAssociation].
 */
public suspend fun resolverFirewallRuleGroupAssociation(
    name: String,
    block: suspend ResolverFirewallRuleGroupAssociationResourceBuilder.() -> Unit,
):
    ResolverFirewallRuleGroupAssociation {
    val builder = ResolverFirewallRuleGroupAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverFirewallRuleGroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverFirewallRuleGroupAssociation(name: String):
    ResolverFirewallRuleGroupAssociation {
    val builder = ResolverFirewallRuleGroupAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
