@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Route 53 Resolver DNS Firewall rule group association resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroup;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociation;
 * import com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleResolverFirewallRuleGroup = new ResolverFirewallRuleGroup("exampleResolverFirewallRuleGroup");
 *         var exampleResolverFirewallRuleGroupAssociation = new ResolverFirewallRuleGroupAssociation("exampleResolverFirewallRuleGroupAssociation", ResolverFirewallRuleGroupAssociationArgs.builder()
 *             .firewallRuleGroupId(exampleResolverFirewallRuleGroup.id())
 *             .priority(100)
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route 53 Resolver DNS Firewall rule group associations using the Route 53 Resolver DNS Firewall rule group association ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverFirewallRuleGroupAssociation:ResolverFirewallRuleGroupAssociation example rslvr-frgassoc-0123456789abcdef
 * ```
 * @property firewallRuleGroupId The unique identifier of the firewall rule group.
 * @property mutationProtection If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. Valid values: `ENABLED`, `DISABLED`.
 * @property name A name that lets you identify the rule group association, to manage and use it.
 * @property priority The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The unique identifier of the VPC that you want to associate with the rule group.
 */
public data class ResolverFirewallRuleGroupAssociationArgs(
    public val firewallRuleGroupId: Output<String>? = null,
    public val mutationProtection: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociationArgs =
        com.pulumi.aws.route53.ResolverFirewallRuleGroupAssociationArgs.builder()
            .firewallRuleGroupId(firewallRuleGroupId?.applyValue({ args0 -> args0 }))
            .mutationProtection(mutationProtection?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverFirewallRuleGroupAssociationArgs].
 */
@PulumiTagMarker
public class ResolverFirewallRuleGroupAssociationArgsBuilder internal constructor() {
    private var firewallRuleGroupId: Output<String>? = null

    private var mutationProtection: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The unique identifier of the firewall rule group.
     */
    @JvmName("ityxglshkqmqnaym")
    public suspend fun firewallRuleGroupId(`value`: Output<String>) {
        this.firewallRuleGroupId = value
    }

    /**
     * @param value If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("nhxvgnqrjkpyrxks")
    public suspend fun mutationProtection(`value`: Output<String>) {
        this.mutationProtection = value
    }

    /**
     * @param value A name that lets you identify the rule group association, to manage and use it.
     */
    @JvmName("edhljtubxndnqklf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.
     */
    @JvmName("breixyuoyiekwdnt")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xcsjsxqyhcpufkkq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique identifier of the VPC that you want to associate with the rule group.
     */
    @JvmName("gxbdjaidbsgnpuwv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The unique identifier of the firewall rule group.
     */
    @JvmName("iwbijgipnacdeouk")
    public suspend fun firewallRuleGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleGroupId = mapped
    }

    /**
     * @param value If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. Valid values: `ENABLED`, `DISABLED`.
     */
    @JvmName("omyqwvxrqbnsbuso")
    public suspend fun mutationProtection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mutationProtection = mapped
    }

    /**
     * @param value A name that lets you identify the rule group association, to manage and use it.
     */
    @JvmName("dslctvxbpdidrtee")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.
     */
    @JvmName("fmrujecrmddpscac")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fgfoaspsuhwvjfjd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ocjaugwmhyxxnmha")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The unique identifier of the VPC that you want to associate with the rule group.
     */
    @JvmName("eivhsvbpvsqlsjox")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ResolverFirewallRuleGroupAssociationArgs =
        ResolverFirewallRuleGroupAssociationArgs(
            firewallRuleGroupId = firewallRuleGroupId,
            mutationProtection = mutationProtection,
            name = name,
            priority = priority,
            tags = tags,
            vpcId = vpcId,
        )
}
