@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResolverQueryLogConfig].
 */
@PulumiTagMarker
public class ResolverQueryLogConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverQueryLogConfigArgs = ResolverQueryLogConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverQueryLogConfigArgsBuilder.() -> Unit) {
        val builder = ResolverQueryLogConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverQueryLogConfig {
        val builtJavaResource = com.pulumi.aws.route53.ResolverQueryLogConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverQueryLogConfig(builtJavaResource)
    }
}

/**
 * Provides a Route 53 Resolver query logging configuration resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverQueryLogConfig;
 * import com.pulumi.aws.route53.ResolverQueryLogConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverQueryLogConfig("example", ResolverQueryLogConfigArgs.builder()
 *             .destinationArn(aws_s3_bucket.example().arn())
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import
 * Route 53 Resolver query logging configurations using the Route 53 Resolver query logging configuration ID. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverQueryLogConfig:ResolverQueryLogConfig example rqlc-92edc3b1838248bf
 * ```
 *
 */
public class ResolverQueryLogConfig internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverQueryLogConfig,
) : KotlinCustomResource(javaResource, ResolverQueryLogConfigMapper) {
    /**
     * The ARN (Amazon Resource Name) of the Route 53 Resolver query logging configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource that you want Route 53 Resolver to send query logs.
     * You can send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery stream.
     */
    public val destinationArn: Output<String>
        get() = javaResource.destinationArn().applyValue({ args0 -> args0 })

    /**
     * The name of the Route 53 Resolver query logging configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the account that created the query logging configuration.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * An indication of whether the query logging configuration is shared with other AWS accounts, or was shared with the current account by another AWS account.
     * Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * Values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
     */
    public val shareStatus: Output<String>
        get() = javaResource.shareStatus().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResolverQueryLogConfigMapper : ResourceMapper<ResolverQueryLogConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverQueryLogConfig::class == javaResource::class

    override fun map(javaResource: Resource): ResolverQueryLogConfig =
        ResolverQueryLogConfig(javaResource as com.pulumi.aws.route53.ResolverQueryLogConfig)
}

/**
 * @see [ResolverQueryLogConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverQueryLogConfig].
 */
public suspend fun resolverQueryLogConfig(
    name: String,
    block: suspend ResolverQueryLogConfigResourceBuilder.() -> Unit,
): ResolverQueryLogConfig {
    val builder = ResolverQueryLogConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverQueryLogConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverQueryLogConfig(name: String): ResolverQueryLogConfig {
    val builder = ResolverQueryLogConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
