@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ResolverRuleArgs.builder
import com.pulumi.aws.route53.kotlin.inputs.ResolverRuleTargetIpArgs
import com.pulumi.aws.route53.kotlin.inputs.ResolverRuleTargetIpArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Route53 Resolver rule.
 * ## Example Usage
 * ### System rule
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRule;
 * import com.pulumi.aws.route53.ResolverRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sys = new ResolverRule("sys", ResolverRuleArgs.builder()
 *             .domainName("subdomain.example.com")
 *             .ruleType("SYSTEM")
 *             .build());
 *     }
 * }
 * ```
 * ### Forward rule
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRule;
 * import com.pulumi.aws.route53.ResolverRuleArgs;
 * import com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fwd = new ResolverRule("fwd", ResolverRuleArgs.builder()
 *             .domainName("example.com")
 *             .ruleType("FORWARD")
 *             .resolverEndpointId(aws_route53_resolver_endpoint.foo().id())
 *             .targetIps(ResolverRuleTargetIpArgs.builder()
 *                 .ip("123.45.67.89")
 *                 .build())
 *             .tags(Map.of("Environment", "Prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Resolver rules using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverRule:ResolverRule sys rslvr-rr-0123456789abcdef0
 * ```
 * @property domainName DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
 * @property name A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
 * @property resolverEndpointId The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
 * This argument should only be specified for `FORWARD` type rules.
 * @property ruleType The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetIps Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
 * This argument should only be specified for `FORWARD` type rules.
 */
public data class ResolverRuleArgs(
    public val domainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resolverEndpointId: Output<String>? = null,
    public val ruleType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetIps: Output<List<ResolverRuleTargetIpArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ResolverRuleArgs> {
    override fun toJava(): com.pulumi.aws.route53.ResolverRuleArgs =
        com.pulumi.aws.route53.ResolverRuleArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resolverEndpointId(resolverEndpointId?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetIps(
                targetIps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResolverRuleArgs].
 */
@PulumiTagMarker
public class ResolverRuleArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var name: Output<String>? = null

    private var resolverEndpointId: Output<String>? = null

    private var ruleType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetIps: Output<List<ResolverRuleTargetIpArgs>>? = null

    /**
     * @param value DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
     */
    @JvmName("mbrfevhunfriwgjd")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    @JvmName("kpukeiooshgeplbw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("ghmsfcfniygqkafg")
    public suspend fun resolverEndpointId(`value`: Output<String>) {
        this.resolverEndpointId = value
    }

    /**
     * @param value The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
     */
    @JvmName("heyrphsbndvcmhqb")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fkryybrcsslpgpsc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("ixuwrhaultlpwykq")
    public suspend fun targetIps(`value`: Output<List<ResolverRuleTargetIpArgs>>) {
        this.targetIps = value
    }

    @JvmName("niykkjhtbbxbfcan")
    public suspend fun targetIps(vararg values: Output<ResolverRuleTargetIpArgs>) {
        this.targetIps = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("pbrsjlaehpforlfq")
    public suspend fun targetIps(values: List<Output<ResolverRuleTargetIpArgs>>) {
        this.targetIps = Output.all(values)
    }

    /**
     * @param value DNS queries for this domain name are forwarded to the IP addresses that are specified using `target_ip`.
     */
    @JvmName("yudktonvtwltdxnh")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    @JvmName("vvturqqijordpphx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you specify using `target_ip`.
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("oqenrdppnqqhicet")
    public suspend fun resolverEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolverEndpointId = mapped
    }

    /**
     * @param value The rule type. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
     */
    @JvmName("orgiqqdpguxsnlfb")
    public suspend fun ruleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lxxhidmiwfdxnyji")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jjsneclviwhkmxhb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("okjhqdpnybomkmqr")
    public suspend fun targetIps(`value`: List<ResolverRuleTargetIpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetIps = mapped
    }

    /**
     * @param argument Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("ohucewjqaokvkmvy")
    public suspend fun targetIps(argument: List<suspend ResolverRuleTargetIpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResolverRuleTargetIpArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetIps = mapped
    }

    /**
     * @param argument Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("hvgvpuytqhqnecwo")
    public suspend fun targetIps(
        vararg
        argument: suspend ResolverRuleTargetIpArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResolverRuleTargetIpArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetIps = mapped
    }

    /**
     * @param argument Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("aglqdkmcouvibdgg")
    public suspend fun targetIps(argument: suspend ResolverRuleTargetIpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResolverRuleTargetIpArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetIps = mapped
    }

    /**
     * @param values Configuration block(s) indicating the IPs that you want Resolver to forward DNS queries to (documented below).
     * This argument should only be specified for `FORWARD` type rules.
     */
    @JvmName("ubomnchmbxthmilq")
    public suspend fun targetIps(vararg values: ResolverRuleTargetIpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetIps = mapped
    }

    internal fun build(): ResolverRuleArgs = ResolverRuleArgs(
        domainName = domainName,
        name = name,
        resolverEndpointId = resolverEndpointId,
        ruleType = ruleType,
        tags = tags,
        targetIps = targetIps,
    )
}
