@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResolverRuleAssociation].
 */
@PulumiTagMarker
public class ResolverRuleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResolverRuleAssociationArgs = ResolverRuleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResolverRuleAssociationArgsBuilder.() -> Unit) {
        val builder = ResolverRuleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResolverRuleAssociation {
        val builtJavaResource = com.pulumi.aws.route53.ResolverRuleAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResolverRuleAssociation(builtJavaResource)
    }
}

/**
 * Provides a Route53 Resolver rule association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.ResolverRuleAssociation;
 * import com.pulumi.aws.route53.ResolverRuleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResolverRuleAssociation("example", ResolverRuleAssociationArgs.builder()
 *             .resolverRuleId(aws_route53_resolver_rule.sys().id())
 *             .vpcId(aws_vpc.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Resolver rule associations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:route53/resolverRuleAssociation:ResolverRuleAssociation example rslvr-rrassoc-97242eaf88example
 * ```
 *
 */
public class ResolverRuleAssociation internal constructor(
    override val javaResource: com.pulumi.aws.route53.ResolverRuleAssociation,
) : KotlinCustomResource(javaResource, ResolverRuleAssociationMapper) {
    /**
     * A name for the association that you're creating between a resolver rule and a VPC.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the resolver rule that you want to associate with the VPC.
     */
    public val resolverRuleId: Output<String>
        get() = javaResource.resolverRuleId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC that you want to associate the resolver rule with.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ResolverRuleAssociationMapper : ResourceMapper<ResolverRuleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ResolverRuleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ResolverRuleAssociation =
        ResolverRuleAssociation(javaResource as com.pulumi.aws.route53.ResolverRuleAssociation)
}

/**
 * @see [ResolverRuleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResolverRuleAssociation].
 */
public suspend fun resolverRuleAssociation(
    name: String,
    block: suspend ResolverRuleAssociationResourceBuilder.() -> Unit,
): ResolverRuleAssociation {
    val builder = ResolverRuleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResolverRuleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resolverRuleAssociation(name: String): ResolverRuleAssociation {
    val builder = ResolverRuleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
