@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.Route53Functions.getDelegationSetPlain
import com.pulumi.aws.route53.Route53Functions.getQueryLogConfigPlain
import com.pulumi.aws.route53.Route53Functions.getResolverEndpointPlain
import com.pulumi.aws.route53.Route53Functions.getResolverFirewallConfigPlain
import com.pulumi.aws.route53.Route53Functions.getResolverFirewallDomainListPlain
import com.pulumi.aws.route53.Route53Functions.getResolverFirewallRuleGroupAssociationPlain
import com.pulumi.aws.route53.Route53Functions.getResolverFirewallRuleGroupPlain
import com.pulumi.aws.route53.Route53Functions.getResolverFirewallRulesPlain
import com.pulumi.aws.route53.Route53Functions.getResolverRulePlain
import com.pulumi.aws.route53.Route53Functions.getResolverRulesPlain
import com.pulumi.aws.route53.Route53Functions.getTrafficPolicyDocumentPlain
import com.pulumi.aws.route53.Route53Functions.getZonePlain
import com.pulumi.aws.route53.kotlin.inputs.GetDelegationSetPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetDelegationSetPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetQueryLogConfigFilter
import com.pulumi.aws.route53.kotlin.inputs.GetQueryLogConfigPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetQueryLogConfigPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverEndpointFilter
import com.pulumi.aws.route53.kotlin.inputs.GetResolverEndpointPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverEndpointPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallConfigPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallConfigPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallDomainListPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallDomainListPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallRuleGroupAssociationPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallRuleGroupAssociationPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallRuleGroupPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallRuleGroupPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallRulesPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverFirewallRulesPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverRulePlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverRulePlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetResolverRulesPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetResolverRulesPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetTrafficPolicyDocumentEndpoint
import com.pulumi.aws.route53.kotlin.inputs.GetTrafficPolicyDocumentPlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetTrafficPolicyDocumentPlainArgsBuilder
import com.pulumi.aws.route53.kotlin.inputs.GetTrafficPolicyDocumentRule
import com.pulumi.aws.route53.kotlin.inputs.GetZonePlainArgs
import com.pulumi.aws.route53.kotlin.inputs.GetZonePlainArgsBuilder
import com.pulumi.aws.route53.kotlin.outputs.GetDelegationSetResult
import com.pulumi.aws.route53.kotlin.outputs.GetQueryLogConfigResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverEndpointResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallConfigResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallDomainListResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRuleGroupAssociationResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRuleGroupResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRulesResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverRuleResult
import com.pulumi.aws.route53.kotlin.outputs.GetResolverRulesResult
import com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentResult
import com.pulumi.aws.route53.kotlin.outputs.GetZoneResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.route53.kotlin.outputs.GetDelegationSetResult.Companion.toKotlin as getDelegationSetResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetQueryLogConfigResult.Companion.toKotlin as getQueryLogConfigResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverEndpointResult.Companion.toKotlin as getResolverEndpointResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallConfigResult.Companion.toKotlin as getResolverFirewallConfigResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallDomainListResult.Companion.toKotlin as getResolverFirewallDomainListResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRuleGroupAssociationResult.Companion.toKotlin as getResolverFirewallRuleGroupAssociationResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRuleGroupResult.Companion.toKotlin as getResolverFirewallRuleGroupResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverFirewallRulesResult.Companion.toKotlin as getResolverFirewallRulesResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverRuleResult.Companion.toKotlin as getResolverRuleResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetResolverRulesResult.Companion.toKotlin as getResolverRulesResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetTrafficPolicyDocumentResult.Companion.toKotlin as getTrafficPolicyDocumentResultToKotlin
import com.pulumi.aws.route53.kotlin.outputs.GetZoneResult.Companion.toKotlin as getZoneResultToKotlin

public object Route53Functions {
    /**
     * `aws.route53.DelegationSet` provides details about a specific Route 53 Delegation Set.
     * This data source allows to find a list of name servers associated with a specific delegation set.
     * ## Example Usage
     * The following example shows how to get a delegation set from its id.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetDelegationSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dset = Route53Functions.getDelegationSet(GetDelegationSetArgs.builder()
     *             .id("MQWGHCBFAKEID")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDelegationSet.
     * @return A collection of values returned by getDelegationSet.
     */
    public suspend fun getDelegationSet(argument: GetDelegationSetPlainArgs): GetDelegationSetResult =
        getDelegationSetResultToKotlin(getDelegationSetPlain(argument.toJava()).await())

    /**
     * @see [getDelegationSet].
     * @param id Delegation set ID.
     * The following attribute is additionally exported:
     * @return A collection of values returned by getDelegationSet.
     */
    public suspend fun getDelegationSet(id: String): GetDelegationSetResult {
        val argument = GetDelegationSetPlainArgs(
            id = id,
        )
        return getDelegationSetResultToKotlin(getDelegationSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getDelegationSet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetDelegationSetPlainArgs].
     * @return A collection of values returned by getDelegationSet.
     */
    public suspend
    fun getDelegationSet(argument: suspend GetDelegationSetPlainArgsBuilder.() -> Unit):
        GetDelegationSetResult {
        val builder = GetDelegationSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDelegationSetResultToKotlin(getDelegationSetPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverQueryLogConfig` provides details about a specific Route53 Resolver Query Logging Configuration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetQueryLogConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getQueryLogConfig(GetQueryLogConfigArgs.builder()
     *             .resolverQueryLogConfigId("rqlc-1abc2345ef678g91h")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getQueryLogConfig.
     * @return A collection of values returned by getQueryLogConfig.
     */
    public suspend fun getQueryLogConfig(argument: GetQueryLogConfigPlainArgs):
        GetQueryLogConfigResult =
        getQueryLogConfigResultToKotlin(getQueryLogConfigPlain(argument.toJava()).await())

    /**
     * @see [getQueryLogConfig].
     * @param filters One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     * @param name The name of the query logging configuration.
     * @param resolverQueryLogConfigId ID of the Route53 Resolver Query Logging Configuration.
     * @param tags Map of tags to assign to the service.
     * [1]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_Filter.html
     * @return A collection of values returned by getQueryLogConfig.
     */
    public suspend fun getQueryLogConfig(
        filters: List<GetQueryLogConfigFilter>? = null,
        name: String? = null,
        resolverQueryLogConfigId: String? = null,
        tags: Map<String, String>? = null,
    ): GetQueryLogConfigResult {
        val argument = GetQueryLogConfigPlainArgs(
            filters = filters,
            name = name,
            resolverQueryLogConfigId = resolverQueryLogConfigId,
            tags = tags,
        )
        return getQueryLogConfigResultToKotlin(getQueryLogConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getQueryLogConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetQueryLogConfigPlainArgs].
     * @return A collection of values returned by getQueryLogConfig.
     */
    public suspend
    fun getQueryLogConfig(argument: suspend GetQueryLogConfigPlainArgsBuilder.() -> Unit):
        GetQueryLogConfigResult {
        val builder = GetQueryLogConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueryLogConfigResultToKotlin(getQueryLogConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverEndpoint` provides details about a specific Route53 Resolver Endpoint.
     * This data source allows to find a list of IPaddresses associated with a specific Route53 Resolver Endpoint.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverEndpoint(GetResolverEndpointArgs.builder()
     *             .resolverEndpointId("rslvr-in-1abc2345ef678g91h")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverEndpoint.
     * @return A collection of values returned by getResolverEndpoint.
     */
    public suspend fun getResolverEndpoint(argument: GetResolverEndpointPlainArgs):
        GetResolverEndpointResult =
        getResolverEndpointResultToKotlin(getResolverEndpointPlain(argument.toJava()).await())

    /**
     * @see [getResolverEndpoint].
     * @param filters One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     * @param resolverEndpointId ID of the Route53 Resolver Endpoint.
     * @return A collection of values returned by getResolverEndpoint.
     */
    public suspend fun getResolverEndpoint(
        filters: List<GetResolverEndpointFilter>? = null,
        resolverEndpointId: String? = null,
    ): GetResolverEndpointResult {
        val argument = GetResolverEndpointPlainArgs(
            filters = filters,
            resolverEndpointId = resolverEndpointId,
        )
        return getResolverEndpointResultToKotlin(getResolverEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverEndpointPlainArgs].
     * @return A collection of values returned by getResolverEndpoint.
     */
    public suspend
    fun getResolverEndpoint(argument: suspend GetResolverEndpointPlainArgsBuilder.() -> Unit):
        GetResolverEndpointResult {
        val builder = GetResolverEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverEndpointResultToKotlin(getResolverEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverFirewallConfig` provides details about a specific a Route 53 Resolver DNS Firewall config.
     * This data source allows to find a details about a specific a Route 53 Resolver DNS Firewall config.
     * ## Example Usage
     * The following example shows how to get a firewall config using the VPC ID.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverFirewallConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverFirewallConfig(GetResolverFirewallConfigArgs.builder()
     *             .resourceId("vpc-exampleid")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverFirewallConfig.
     * @return A collection of values returned by getResolverFirewallConfig.
     */
    public suspend fun getResolverFirewallConfig(argument: GetResolverFirewallConfigPlainArgs):
        GetResolverFirewallConfigResult =
        getResolverFirewallConfigResultToKotlin(getResolverFirewallConfigPlain(argument.toJava()).await())

    /**
     * @see [getResolverFirewallConfig].
     * @param resourceId The ID of the VPC from Amazon VPC that the configuration is for.
     * The following attribute is additionally exported:
     * @return A collection of values returned by getResolverFirewallConfig.
     */
    public suspend fun getResolverFirewallConfig(resourceId: String):
        GetResolverFirewallConfigResult {
        val argument = GetResolverFirewallConfigPlainArgs(
            resourceId = resourceId,
        )
        return getResolverFirewallConfigResultToKotlin(getResolverFirewallConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverFirewallConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverFirewallConfigPlainArgs].
     * @return A collection of values returned by getResolverFirewallConfig.
     */
    public suspend
    fun getResolverFirewallConfig(argument: suspend GetResolverFirewallConfigPlainArgsBuilder.() -> Unit):
        GetResolverFirewallConfigResult {
        val builder = GetResolverFirewallConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverFirewallConfigResultToKotlin(getResolverFirewallConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverFirewallDomainList` Retrieves the specified firewall domain list.
     * This data source allows to retrieve details about a specific a Route 53 Resolver DNS Firewall domain list.
     * ## Example Usage
     * The following example shows how to get a firewall domain list from its ID.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverFirewallDomainListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverFirewallDomainList(GetResolverFirewallDomainListArgs.builder()
     *             .firewallDomainListId("rslvr-fdl-example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverFirewallDomainList.
     * @return A collection of values returned by getResolverFirewallDomainList.
     */
    public suspend
    fun getResolverFirewallDomainList(argument: GetResolverFirewallDomainListPlainArgs):
        GetResolverFirewallDomainListResult =
        getResolverFirewallDomainListResultToKotlin(getResolverFirewallDomainListPlain(argument.toJava()).await())

    /**
     * @see [getResolverFirewallDomainList].
     * @param firewallDomainListId The ID of the domain list.
     * The following attribute is additionally exported:
     * @return A collection of values returned by getResolverFirewallDomainList.
     */
    public suspend fun getResolverFirewallDomainList(firewallDomainListId: String):
        GetResolverFirewallDomainListResult {
        val argument = GetResolverFirewallDomainListPlainArgs(
            firewallDomainListId = firewallDomainListId,
        )
        return getResolverFirewallDomainListResultToKotlin(getResolverFirewallDomainListPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverFirewallDomainList].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverFirewallDomainListPlainArgs].
     * @return A collection of values returned by getResolverFirewallDomainList.
     */
    public suspend
    fun getResolverFirewallDomainList(argument: suspend GetResolverFirewallDomainListPlainArgsBuilder.() -> Unit):
        GetResolverFirewallDomainListResult {
        val builder = GetResolverFirewallDomainListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverFirewallDomainListResultToKotlin(getResolverFirewallDomainListPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverFirewallRuleGroup` Retrieves the specified firewall rule group.
     * This data source allows to retrieve details about a specific a Route 53 Resolver DNS Firewall rule group.
     * ## Example Usage
     * The following example shows how to get a firewall rule group from its ID.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverFirewallRuleGroup(GetResolverFirewallRuleGroupArgs.builder()
     *             .firewallRuleGroupId("rslvr-frg-example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverFirewallRuleGroup.
     * @return A collection of values returned by getResolverFirewallRuleGroup.
     */
    public suspend fun getResolverFirewallRuleGroup(argument: GetResolverFirewallRuleGroupPlainArgs):
        GetResolverFirewallRuleGroupResult =
        getResolverFirewallRuleGroupResultToKotlin(getResolverFirewallRuleGroupPlain(argument.toJava()).await())

    /**
     * @see [getResolverFirewallRuleGroup].
     * @param firewallRuleGroupId The ID of the rule group.
     * The following attribute is additionally exported:
     * @return A collection of values returned by getResolverFirewallRuleGroup.
     */
    public suspend fun getResolverFirewallRuleGroup(firewallRuleGroupId: String):
        GetResolverFirewallRuleGroupResult {
        val argument = GetResolverFirewallRuleGroupPlainArgs(
            firewallRuleGroupId = firewallRuleGroupId,
        )
        return getResolverFirewallRuleGroupResultToKotlin(getResolverFirewallRuleGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverFirewallRuleGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverFirewallRuleGroupPlainArgs].
     * @return A collection of values returned by getResolverFirewallRuleGroup.
     */
    public suspend
    fun getResolverFirewallRuleGroup(argument: suspend GetResolverFirewallRuleGroupPlainArgsBuilder.() -> Unit):
        GetResolverFirewallRuleGroupResult {
        val builder = GetResolverFirewallRuleGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverFirewallRuleGroupResultToKotlin(getResolverFirewallRuleGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverFirewallRuleGroupAssociation` Retrieves the specified firewall rule group association.
     * This data source allows to retrieve details about a specific a Route 53 Resolver DNS Firewall rule group association.
     * ## Example Usage
     * The following example shows how to get a firewall rule group association from its id.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupAssociationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverFirewallRuleGroupAssociation(GetResolverFirewallRuleGroupAssociationArgs.builder()
     *             .firewallRuleGroupAssociationId("rslvr-frgassoc-example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverFirewallRuleGroupAssociation.
     * @return A collection of values returned by getResolverFirewallRuleGroupAssociation.
     */
    public suspend
    fun getResolverFirewallRuleGroupAssociation(argument: GetResolverFirewallRuleGroupAssociationPlainArgs):
        GetResolverFirewallRuleGroupAssociationResult =
        getResolverFirewallRuleGroupAssociationResultToKotlin(getResolverFirewallRuleGroupAssociationPlain(argument.toJava()).await())

    /**
     * @see [getResolverFirewallRuleGroupAssociation].
     * @param firewallRuleGroupAssociationId The identifier for the association.
     * The following attribute is additionally exported:
     * @return A collection of values returned by getResolverFirewallRuleGroupAssociation.
     */
    public suspend
    fun getResolverFirewallRuleGroupAssociation(firewallRuleGroupAssociationId: String):
        GetResolverFirewallRuleGroupAssociationResult {
        val argument = GetResolverFirewallRuleGroupAssociationPlainArgs(
            firewallRuleGroupAssociationId = firewallRuleGroupAssociationId,
        )
        return getResolverFirewallRuleGroupAssociationResultToKotlin(getResolverFirewallRuleGroupAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverFirewallRuleGroupAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverFirewallRuleGroupAssociationPlainArgs].
     * @return A collection of values returned by getResolverFirewallRuleGroupAssociation.
     */
    public suspend
    fun getResolverFirewallRuleGroupAssociation(argument: suspend GetResolverFirewallRuleGroupAssociationPlainArgsBuilder.() -> Unit):
        GetResolverFirewallRuleGroupAssociationResult {
        val builder = GetResolverFirewallRuleGroupAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverFirewallRuleGroupAssociationResultToKotlin(getResolverFirewallRuleGroupAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.getResolverFirewallRules` Provides details about rules in a specific Route53 Resolver Firewall rule group.
     * ## Example Usage
     * The following example shows how to get Route53 Resolver Firewall rules based on its associated firewall group id.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverFirewallRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverFirewallRules(GetResolverFirewallRulesArgs.builder()
     *             .firewallRuleGroupId(aws_route53_resolver_firewall_rule_group.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverFirewallRules.
     * @return A collection of values returned by getResolverFirewallRules.
     */
    public suspend fun getResolverFirewallRules(argument: GetResolverFirewallRulesPlainArgs):
        GetResolverFirewallRulesResult =
        getResolverFirewallRulesResultToKotlin(getResolverFirewallRulesPlain(argument.toJava()).await())

    /**
     * @see [getResolverFirewallRules].
     * @param action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
     * @param firewallRuleGroupId The unique identifier of the firewall rule group that you want to retrieve the rules for.
     * @param priority The setting that determines the processing order of the rules in a rule group.
     * @return A collection of values returned by getResolverFirewallRules.
     */
    public suspend fun getResolverFirewallRules(
        action: String? = null,
        firewallRuleGroupId: String,
        priority: Int? = null,
    ): GetResolverFirewallRulesResult {
        val argument = GetResolverFirewallRulesPlainArgs(
            action = action,
            firewallRuleGroupId = firewallRuleGroupId,
            priority = priority,
        )
        return getResolverFirewallRulesResultToKotlin(getResolverFirewallRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverFirewallRules].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverFirewallRulesPlainArgs].
     * @return A collection of values returned by getResolverFirewallRules.
     */
    public suspend
    fun getResolverFirewallRules(argument: suspend GetResolverFirewallRulesPlainArgsBuilder.() -> Unit):
        GetResolverFirewallRulesResult {
        val builder = GetResolverFirewallRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverFirewallRulesResultToKotlin(getResolverFirewallRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.ResolverRule` provides details about a specific Route53 Resolver rule.
     * ## Example Usage
     * The following example shows how to get a Route53 Resolver rule based on its associated domain name and rule type.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverRule(GetResolverRuleArgs.builder()
     *             .domainName("subdomain.example.com")
     *             .ruleType("SYSTEM")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverRule.
     * @return A collection of values returned by getResolverRule.
     */
    public suspend fun getResolverRule(argument: GetResolverRulePlainArgs): GetResolverRuleResult =
        getResolverRuleResultToKotlin(getResolverRulePlain(argument.toJava()).await())

    /**
     * @see [getResolverRule].
     * @param domainName Domain name the desired resolver rule forwards DNS queries for. Conflicts with `resolver_rule_id`.
     * @param name Friendly name of the desired resolver rule. Conflicts with `resolver_rule_id`.
     * @param resolverEndpointId ID of the outbound resolver endpoint of the desired resolver rule. Conflicts with `resolver_rule_id`.
     * @param resolverRuleId ID of the desired resolver rule. Conflicts with `domain_name`, `name`, `resolver_endpoint_id` and `rule_type`.
     * @param ruleType Rule type of the desired resolver rule. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`. Conflicts with `resolver_rule_id`.
     * @param tags Map of tags assigned to the resolver rule.
     * @return A collection of values returned by getResolverRule.
     */
    public suspend fun getResolverRule(
        domainName: String? = null,
        name: String? = null,
        resolverEndpointId: String? = null,
        resolverRuleId: String? = null,
        ruleType: String? = null,
        tags: Map<String, String>? = null,
    ): GetResolverRuleResult {
        val argument = GetResolverRulePlainArgs(
            domainName = domainName,
            name = name,
            resolverEndpointId = resolverEndpointId,
            resolverRuleId = resolverRuleId,
            ruleType = ruleType,
            tags = tags,
        )
        return getResolverRuleResultToKotlin(getResolverRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverRulePlainArgs].
     * @return A collection of values returned by getResolverRule.
     */
    public suspend fun getResolverRule(argument: suspend GetResolverRulePlainArgsBuilder.() -> Unit):
        GetResolverRuleResult {
        val builder = GetResolverRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverRuleResultToKotlin(getResolverRulePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.getResolverRules` provides details about a set of Route53 Resolver rules.
     * ## Example Usage
     * ### Retrieving the default resolver rule
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverRules(GetResolverRulesArgs.builder()
     *             .ownerId("Route 53 Resolver")
     *             .ruleType("RECURSIVE")
     *             .shareStatus("NOT_SHARED")
     *             .build());
     *     }
     * }
     * ```
     * ### Retrieving forward rules shared with me
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverRules(GetResolverRulesArgs.builder()
     *             .ruleType("FORWARD")
     *             .shareStatus("SHARED_WITH_ME")
     *             .build());
     *     }
     * }
     * ```
     * ### Retrieving rules by name regex
     * Resolver rules whose name contains `abc`.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetResolverRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Route53Functions.getResolverRules(GetResolverRulesArgs.builder()
     *             .nameRegex(".*abc.*")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResolverRules.
     * @return A collection of values returned by getResolverRules.
     */
    public suspend fun getResolverRules(argument: GetResolverRulesPlainArgs): GetResolverRulesResult =
        getResolverRulesResultToKotlin(getResolverRulesPlain(argument.toJava()).await())

    /**
     * @see [getResolverRules].
     * @param nameRegex Regex string to filter resolver rule names.
     * The filtering is done locally, so could have a performance impact if the result is large.
     * This argument should be used along with other arguments to limit the number of results returned.
     * @param ownerId When the desired resolver rules are shared with another AWS account, the account ID of the account that the rules are shared with.
     * @param resolverEndpointId ID of the outbound resolver endpoint for the desired resolver rules.
     * @param ruleType Rule type of the desired resolver rules. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`.
     * @param shareStatus Whether the desired resolver rules are shared and, if so, whether the current account is sharing the rules with another account, or another account is sharing the rules with the current account. Valid values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
     * @return A collection of values returned by getResolverRules.
     */
    public suspend fun getResolverRules(
        nameRegex: String? = null,
        ownerId: String? = null,
        resolverEndpointId: String? = null,
        ruleType: String? = null,
        shareStatus: String? = null,
    ): GetResolverRulesResult {
        val argument = GetResolverRulesPlainArgs(
            nameRegex = nameRegex,
            ownerId = ownerId,
            resolverEndpointId = resolverEndpointId,
            ruleType = ruleType,
            shareStatus = shareStatus,
        )
        return getResolverRulesResultToKotlin(getResolverRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverRules].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetResolverRulesPlainArgs].
     * @return A collection of values returned by getResolverRules.
     */
    public suspend
    fun getResolverRules(argument: suspend GetResolverRulesPlainArgsBuilder.() -> Unit):
        GetResolverRulesResult {
        val builder = GetResolverRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverRulesResultToKotlin(getResolverRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * Generates an Route53 traffic policy document in JSON format for use with resources that expect policy documents such as `aws.route53.TrafficPolicy`.
     * ## Example Usage
     * ### Basic Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentArgs;
     * import com.pulumi.aws.route53.TrafficPolicy;
     * import com.pulumi.aws.route53.TrafficPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *         final var exampleTrafficPolicyDocument = Route53Functions.getTrafficPolicyDocument(GetTrafficPolicyDocumentArgs.builder()
     *             .recordType("A")
     *             .startRule("site_switch")
     *             .endpoints(
     *                 GetTrafficPolicyDocumentEndpointArgs.builder()
     *                     .id("my_elb")
     *                     .type("elastic-load-balancer")
     *                     .value(String.format("elb-111111.%s.elb.amazonaws.com", current.applyValue(getRegionResult -> getRegionResult.name())))
     *                     .build(),
     *                 GetTrafficPolicyDocumentEndpointArgs.builder()
     *                     .id("site_down_banner")
     *                     .type("s3-website")
     *                     .region(current.applyValue(getRegionResult -> getRegionResult.name()))
     *                     .value("www.example.com")
     *                     .build())
     *             .rules(GetTrafficPolicyDocumentRuleArgs.builder()
     *                 .id("site_switch")
     *                 .type("failover")
     *                 .primary(GetTrafficPolicyDocumentRulePrimaryArgs.builder()
     *                     .endpointReference("my_elb")
     *                     .build())
     *                 .secondary(GetTrafficPolicyDocumentRuleSecondaryArgs.builder()
     *                     .endpointReference("site_down_banner")
     *                     .build())
     *                 .build())
     *             .build());
     *         var exampleTrafficPolicy = new TrafficPolicy("exampleTrafficPolicy", TrafficPolicyArgs.builder()
     *             .comment("example comment")
     *             .document(exampleTrafficPolicyDocument.applyValue(getTrafficPolicyDocumentResult -> getTrafficPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * ### Complex Example
     * The following example showcases the use of nested rules within the traffic policy document and introduces the `geoproximity` rule type.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentArgs;
     * import com.pulumi.aws.route53.TrafficPolicy;
     * import com.pulumi.aws.route53.TrafficPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleTrafficPolicyDocument = Route53Functions.getTrafficPolicyDocument(GetTrafficPolicyDocumentArgs.builder()
     *             .recordType("A")
     *             .startRule("geoproximity_rule")
     *             .endpoints(
     *                 GetTrafficPolicyDocumentEndpointArgs.builder()
     *                     .id("na_endpoint_a")
     *                     .type("elastic-load-balancer")
     *                     .value("elb-111111.us-west-1.elb.amazonaws.com")
     *                     .build(),
     *                 GetTrafficPolicyDocumentEndpointArgs.builder()
     *                     .id("na_endpoint_b")
     *                     .type("elastic-load-balancer")
     *                     .value("elb-222222.us-west-1.elb.amazonaws.com")
     *                     .build(),
     *                 GetTrafficPolicyDocumentEndpointArgs.builder()
     *                     .id("eu_endpoint")
     *                     .type("elastic-load-balancer")
     *                     .value("elb-333333.eu-west-1.elb.amazonaws.com")
     *                     .build(),
     *                 GetTrafficPolicyDocumentEndpointArgs.builder()
     *                     .id("ap_endpoint")
     *                     .type("elastic-load-balancer")
     *                     .value("elb-444444.ap-northeast-2.elb.amazonaws.com")
     *                     .build())
     *             .rules(
     *                 GetTrafficPolicyDocumentRuleArgs.builder()
     *                     .id("na_rule")
     *                     .type("failover")
     *                     .primary(GetTrafficPolicyDocumentRulePrimaryArgs.builder()
     *                         .endpointReference("na_endpoint_a")
     *                         .build())
     *                     .secondary(GetTrafficPolicyDocumentRuleSecondaryArgs.builder()
     *                         .endpointReference("na_endpoint_b")
     *                         .build())
     *                     .build(),
     *                 GetTrafficPolicyDocumentRuleArgs.builder()
     *                     .id("geoproximity_rule")
     *                     .type("geoproximity")
     *                     .geoProximityLocations(
     *                         GetTrafficPolicyDocumentRuleGeoProximityLocationArgs.builder()
     *                             .region("aws:route53:us-west-1")
     *                             .bias(10)
     *                             .evaluateTargetHealth(true)
     *                             .ruleReference("na_rule")
     *                             .build(),
     *                         GetTrafficPolicyDocumentRuleGeoProximityLocationArgs.builder()
     *                             .region("aws:route53:eu-west-1")
     *                             .bias(10)
     *                             .evaluateTargetHealth(true)
     *                             .endpointReference("eu_endpoint")
     *                             .build(),
     *                         GetTrafficPolicyDocumentRuleGeoProximityLocationArgs.builder()
     *                             .region("aws:route53:ap-northeast-2")
     *                             .bias(0)
     *                             .evaluateTargetHealth(true)
     *                             .endpointReference("ap_endpoint")
     *                             .build())
     *                     .build())
     *             .build());
     *         var exampleTrafficPolicy = new TrafficPolicy("exampleTrafficPolicy", TrafficPolicyArgs.builder()
     *             .comment("example comment")
     *             .document(exampleTrafficPolicyDocument.applyValue(getTrafficPolicyDocumentResult -> getTrafficPolicyDocumentResult.json()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTrafficPolicyDocument.
     * @return A collection of values returned by getTrafficPolicyDocument.
     */
    public suspend fun getTrafficPolicyDocument(argument: GetTrafficPolicyDocumentPlainArgs):
        GetTrafficPolicyDocumentResult =
        getTrafficPolicyDocumentResultToKotlin(getTrafficPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getTrafficPolicyDocument].
     * @param endpoints Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
     * @param recordType DNS type of all of the resource record sets that Amazon Route 53 will create based on this traffic policy.
     * @param rules Configuration block for definitions of the rules that you want to use in this traffic policy. See below
     * @param startEndpoint An endpoint to be as the starting point for the traffic policy.
     * @param startRule A rule to be as the starting point for the traffic policy.
     * @param version Version of the traffic policy format.
     * @return A collection of values returned by getTrafficPolicyDocument.
     */
    public suspend fun getTrafficPolicyDocument(
        endpoints: List<GetTrafficPolicyDocumentEndpoint>? = null,
        recordType: String? = null,
        rules: List<GetTrafficPolicyDocumentRule>? = null,
        startEndpoint: String? = null,
        startRule: String? = null,
        version: String? = null,
    ): GetTrafficPolicyDocumentResult {
        val argument = GetTrafficPolicyDocumentPlainArgs(
            endpoints = endpoints,
            recordType = recordType,
            rules = rules,
            startEndpoint = startEndpoint,
            startRule = startRule,
            version = version,
        )
        return getTrafficPolicyDocumentResultToKotlin(getTrafficPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrafficPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetTrafficPolicyDocumentPlainArgs].
     * @return A collection of values returned by getTrafficPolicyDocument.
     */
    public suspend
    fun getTrafficPolicyDocument(argument: suspend GetTrafficPolicyDocumentPlainArgsBuilder.() -> Unit):
        GetTrafficPolicyDocumentResult {
        val builder = GetTrafficPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrafficPolicyDocumentResultToKotlin(getTrafficPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.route53.Zone` provides details about a specific Route 53 Hosted Zone.
     * This data source allows to find a Hosted Zone ID given Hosted Zone name and certain search criteria.
     * ## Example Usage
     * The following example shows how to get a Hosted Zone from its name and from this data how to create a Record Set.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.route53.Route53Functions;
     * import com.pulumi.aws.route53.inputs.GetZoneArgs;
     * import com.pulumi.aws.route53.Record;
     * import com.pulumi.aws.route53.RecordArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = Route53Functions.getZone(GetZoneArgs.builder()
     *             .name("test.com.")
     *             .privateZone(true)
     *             .build());
     *         var www = new Record("www", RecordArgs.builder()
     *             .zoneId(selected.applyValue(getZoneResult -> getZoneResult.zoneId()))
     *             .name(String.format("www.%s", selected.applyValue(getZoneResult -> getZoneResult.name())))
     *             .type("A")
     *             .ttl("300")
     *             .records("10.0.0.1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getZone.
     * @return A collection of values returned by getZone.
     */
    public suspend fun getZone(argument: GetZonePlainArgs): GetZoneResult =
        getZoneResultToKotlin(getZonePlain(argument.toJava()).await())

    /**
     * @see [getZone].
     * @param name Hosted Zone name of the desired Hosted Zone.
     * @param privateZone Used with `name` field to get a private Hosted Zone.
     * @param resourceRecordSetCount The number of Record Set in the Hosted Zone.
     * @param tags Used with `name` field. A map of tags, each pair of which must exactly match a pair on the desired Hosted Zone.
     * @param vpcId Used with `name` field to get a private Hosted Zone associated with the vpc_id (in this case, private_zone is not mandatory).
     * @param zoneId Hosted Zone id of the desired Hosted Zone.
     * @return A collection of values returned by getZone.
     */
    public suspend fun getZone(
        name: String? = null,
        privateZone: Boolean? = null,
        resourceRecordSetCount: Int? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
        zoneId: String? = null,
    ): GetZoneResult {
        val argument = GetZonePlainArgs(
            name = name,
            privateZone = privateZone,
            resourceRecordSetCount = resourceRecordSetCount,
            tags = tags,
            vpcId = vpcId,
            zoneId = zoneId,
        )
        return getZoneResultToKotlin(getZonePlain(argument.toJava()).await())
    }

    /**
     * @see [getZone].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;route53&#46;kotlin&#46;inputs&#46;GetZonePlainArgs].
     * @return A collection of values returned by getZone.
     */
    public suspend fun getZone(argument: suspend GetZonePlainArgsBuilder.() -> Unit): GetZoneResult {
        val builder = GetZonePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZoneResultToKotlin(getZonePlain(builtArgument.toJava()).await())
    }
}
