@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.TrafficPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Route53 Traffic Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.TrafficPolicy;
 * import com.pulumi.aws.route53.TrafficPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrafficPolicy("example", TrafficPolicyArgs.builder()
 *             .comment("example comment")
 *             .document("""
 * {
 *   "AWSPolicyFormatVersion": "2015-10-01",
 *   "RecordType": "A",
 *   "Endpoints": {
 *     "endpoint-start-NkPh": {
 *       "Type": "value",
 *       "Value": "10.0.0.2"
 *     }
 *   },
 *   "StartEndpoint": "endpoint-start-NkPh"
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Traffic Policy using the `id` and `version`. For example:
 * ```sh
 *  $ pulumi import aws:route53/trafficPolicy:TrafficPolicy example 01a52019-d16f-422a-ae72-c306d2b6df7e/1
 * ```
 * @property comment Comment for the traffic policy.
 * @property document Policy document. This is a JSON formatted string. For more information about building Route53 traffic policy documents, see the [AWS Route53 Traffic Policy document format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html)
 * The following arguments are optional:
 * @property name Name of the traffic policy.
 */
public data class TrafficPolicyArgs(
    public val comment: Output<String>? = null,
    public val document: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.TrafficPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.TrafficPolicyArgs =
        com.pulumi.aws.route53.TrafficPolicyArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .document(document?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficPolicyArgs].
 */
@PulumiTagMarker
public class TrafficPolicyArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var document: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Comment for the traffic policy.
     */
    @JvmName("qxypdlgnnfwbkvjq")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Policy document. This is a JSON formatted string. For more information about building Route53 traffic policy documents, see the [AWS Route53 Traffic Policy document format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html)
     * The following arguments are optional:
     */
    @JvmName("khrjgqmhdtodfrda")
    public suspend fun document(`value`: Output<String>) {
        this.document = value
    }

    /**
     * @param value Name of the traffic policy.
     */
    @JvmName("akoxnexiqnydxmaj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Comment for the traffic policy.
     */
    @JvmName("jnyarjikncbkmcyp")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Policy document. This is a JSON formatted string. For more information about building Route53 traffic policy documents, see the [AWS Route53 Traffic Policy document format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html)
     * The following arguments are optional:
     */
    @JvmName("ijqbmhhfhypwpdgt")
    public suspend fun document(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.document = mapped
    }

    /**
     * @param value Name of the traffic policy.
     */
    @JvmName("lgrgnnbwnvjthsbb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TrafficPolicyArgs = TrafficPolicyArgs(
        comment = comment,
        document = document,
        name = name,
    )
}
