@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.TrafficPolicyInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Route53 traffic policy instance resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.TrafficPolicyInstance;
 * import com.pulumi.aws.route53.TrafficPolicyInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TrafficPolicyInstance("test", TrafficPolicyInstanceArgs.builder()
 *             .hostedZoneId("Z033120931TAQO548OGJC")
 *             .trafficPolicyId("b3gb108f-ea6f-45a5-baab-9d112d8b4037")
 *             .trafficPolicyVersion(1)
 *             .ttl(360)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 traffic policy instance using its id. For example:
 * ```sh
 *  $ pulumi import aws:route53/trafficPolicyInstance:TrafficPolicyInstance test df579d9a-6396-410e-ac22-e7ad60cf9e7e
 * ```
 * @property hostedZoneId ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
 * @property name Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
 * @property trafficPolicyId ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
 * @property trafficPolicyVersion Version of the traffic policy
 * @property ttl TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
 */
public data class TrafficPolicyInstanceArgs(
    public val hostedZoneId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val trafficPolicyId: Output<String>? = null,
    public val trafficPolicyVersion: Output<Int>? = null,
    public val ttl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.TrafficPolicyInstanceArgs> {
    override fun toJava(): com.pulumi.aws.route53.TrafficPolicyInstanceArgs =
        com.pulumi.aws.route53.TrafficPolicyInstanceArgs.builder()
            .hostedZoneId(hostedZoneId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .trafficPolicyId(trafficPolicyId?.applyValue({ args0 -> args0 }))
            .trafficPolicyVersion(trafficPolicyVersion?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficPolicyInstanceArgs].
 */
@PulumiTagMarker
public class TrafficPolicyInstanceArgsBuilder internal constructor() {
    private var hostedZoneId: Output<String>? = null

    private var name: Output<String>? = null

    private var trafficPolicyId: Output<String>? = null

    private var trafficPolicyVersion: Output<Int>? = null

    private var ttl: Output<Int>? = null

    /**
     * @param value ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     */
    @JvmName("jeudleuceyfcxyjs")
    public suspend fun hostedZoneId(`value`: Output<String>) {
        this.hostedZoneId = value
    }

    /**
     * @param value Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     */
    @JvmName("uwnyeptgjhcsocpg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    @JvmName("dmogmeciwemwrogd")
    public suspend fun trafficPolicyId(`value`: Output<String>) {
        this.trafficPolicyId = value
    }

    /**
     * @param value Version of the traffic policy
     */
    @JvmName("ucxchxaqgjyikxbl")
    public suspend fun trafficPolicyVersion(`value`: Output<Int>) {
        this.trafficPolicyVersion = value
    }

    /**
     * @param value TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     */
    @JvmName("embgwhwuanyjedxy")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     */
    @JvmName("xtidrfplsdishmkn")
    public suspend fun hostedZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostedZoneId = mapped
    }

    /**
     * @param value Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     */
    @JvmName("ylpokoyyqklraktk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     */
    @JvmName("frjcdogwhtbvjirq")
    public suspend fun trafficPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPolicyId = mapped
    }

    /**
     * @param value Version of the traffic policy
     */
    @JvmName("rltbdfbmiygysntd")
    public suspend fun trafficPolicyVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPolicyVersion = mapped
    }

    /**
     * @param value TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     */
    @JvmName("igelgssukgerinby")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): TrafficPolicyInstanceArgs = TrafficPolicyInstanceArgs(
        hostedZoneId = hostedZoneId,
        name = name,
        trafficPolicyId = trafficPolicyId,
        trafficPolicyVersion = trafficPolicyVersion,
        ttl = ttl,
    )
}
