@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcAssociationAuthorization].
 */
@PulumiTagMarker
public class VpcAssociationAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcAssociationAuthorizationArgs = VpcAssociationAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcAssociationAuthorizationArgsBuilder.() -> Unit) {
        val builder = VpcAssociationAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcAssociationAuthorization {
        val builtJavaResource =
            com.pulumi.aws.route53.VpcAssociationAuthorization(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcAssociationAuthorization(builtJavaResource)
    }
}

/**
 * Authorizes a VPC in a different account to be associated with a local Route53 Hosted Zone.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.inputs.ZoneVpcArgs;
 * import com.pulumi.aws.route53.VpcAssociationAuthorization;
 * import com.pulumi.aws.route53.VpcAssociationAuthorizationArgs;
 * import com.pulumi.aws.route53.ZoneAssociation;
 * import com.pulumi.aws.route53.ZoneAssociationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alternate = new Provider("alternate");
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.6.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build());
 *         var exampleZone = new Zone("exampleZone", ZoneArgs.builder()
 *             .vpcs(ZoneVpcArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .build())
 *             .build());
 *         var alternateVpc = new Vpc("alternateVpc", VpcArgs.builder()
 *             .cidrBlock("10.7.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         var exampleVpcAssociationAuthorization = new VpcAssociationAuthorization("exampleVpcAssociationAuthorization", VpcAssociationAuthorizationArgs.builder()
 *             .vpcId(alternateVpc.id())
 *             .zoneId(exampleZone.id())
 *             .build());
 *         var exampleZoneAssociation = new ZoneAssociation("exampleZoneAssociation", ZoneAssociationArgs.builder()
 *             .vpcId(exampleVpcAssociationAuthorization.vpcId())
 *             .zoneId(exampleVpcAssociationAuthorization.zoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route 53 VPC Association Authorizations using the Hosted Zone ID and VPC ID, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:route53/vpcAssociationAuthorization:VpcAssociationAuthorization example Z123456ABCDEFG:vpc-12345678
 * ```
 *
 */
public class VpcAssociationAuthorization internal constructor(
    override val javaResource: com.pulumi.aws.route53.VpcAssociationAuthorization,
) : KotlinCustomResource(javaResource, VpcAssociationAuthorizationMapper) {
    /**
     * The VPC to authorize for association with the private hosted zone.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The VPC's region. Defaults to the region of the AWS provider.
     */
    public val vpcRegion: Output<String>
        get() = javaResource.vpcRegion().applyValue({ args0 -> args0 })

    /**
     * The ID of the private hosted zone that you want to authorize associating a VPC with.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object VpcAssociationAuthorizationMapper : ResourceMapper<VpcAssociationAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.VpcAssociationAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): VpcAssociationAuthorization =
        VpcAssociationAuthorization(
            javaResource as
                com.pulumi.aws.route53.VpcAssociationAuthorization,
        )
}

/**
 * @see [VpcAssociationAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcAssociationAuthorization].
 */
public suspend fun vpcAssociationAuthorization(
    name: String,
    block: suspend VpcAssociationAuthorizationResourceBuilder.() -> Unit,
):
    VpcAssociationAuthorization {
    val builder = VpcAssociationAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcAssociationAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcAssociationAuthorization(name: String): VpcAssociationAuthorization {
    val builder = VpcAssociationAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
