@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.VpcAssociationAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorizes a VPC in a different account to be associated with a local Route53 Hosted Zone.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.inputs.ZoneVpcArgs;
 * import com.pulumi.aws.route53.VpcAssociationAuthorization;
 * import com.pulumi.aws.route53.VpcAssociationAuthorizationArgs;
 * import com.pulumi.aws.route53.ZoneAssociation;
 * import com.pulumi.aws.route53.ZoneAssociationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alternate = new Provider("alternate");
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.6.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build());
 *         var exampleZone = new Zone("exampleZone", ZoneArgs.builder()
 *             .vpcs(ZoneVpcArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .build())
 *             .build());
 *         var alternateVpc = new Vpc("alternateVpc", VpcArgs.builder()
 *             .cidrBlock("10.7.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         var exampleVpcAssociationAuthorization = new VpcAssociationAuthorization("exampleVpcAssociationAuthorization", VpcAssociationAuthorizationArgs.builder()
 *             .vpcId(alternateVpc.id())
 *             .zoneId(exampleZone.id())
 *             .build());
 *         var exampleZoneAssociation = new ZoneAssociation("exampleZoneAssociation", ZoneAssociationArgs.builder()
 *             .vpcId(exampleVpcAssociationAuthorization.vpcId())
 *             .zoneId(exampleVpcAssociationAuthorization.zoneId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route 53 VPC Association Authorizations using the Hosted Zone ID and VPC ID, separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:route53/vpcAssociationAuthorization:VpcAssociationAuthorization example Z123456ABCDEFG:vpc-12345678
 * ```
 * @property vpcId The VPC to authorize for association with the private hosted zone.
 * @property vpcRegion The VPC's region. Defaults to the region of the AWS provider.
 * @property zoneId The ID of the private hosted zone that you want to authorize associating a VPC with.
 */
public data class VpcAssociationAuthorizationArgs(
    public val vpcId: Output<String>? = null,
    public val vpcRegion: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.VpcAssociationAuthorizationArgs> {
    override fun toJava(): com.pulumi.aws.route53.VpcAssociationAuthorizationArgs =
        com.pulumi.aws.route53.VpcAssociationAuthorizationArgs.builder()
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcRegion(vpcRegion?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcAssociationAuthorizationArgs].
 */
@PulumiTagMarker
public class VpcAssociationAuthorizationArgsBuilder internal constructor() {
    private var vpcId: Output<String>? = null

    private var vpcRegion: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The VPC to authorize for association with the private hosted zone.
     */
    @JvmName("xhesjbbfofuqbeel")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The VPC's region. Defaults to the region of the AWS provider.
     */
    @JvmName("wntlqbfafhwjaxai")
    public suspend fun vpcRegion(`value`: Output<String>) {
        this.vpcRegion = value
    }

    /**
     * @param value The ID of the private hosted zone that you want to authorize associating a VPC with.
     */
    @JvmName("uakayxrrgcjkypcw")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The VPC to authorize for association with the private hosted zone.
     */
    @JvmName("tphxxwbesjvpisay")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The VPC's region. Defaults to the region of the AWS provider.
     */
    @JvmName("hexypyjpaansrbbh")
    public suspend fun vpcRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcRegion = mapped
    }

    /**
     * @param value The ID of the private hosted zone that you want to authorize associating a VPC with.
     */
    @JvmName("ptvphcnuuxborkth")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): VpcAssociationAuthorizationArgs = VpcAssociationAuthorizationArgs(
        vpcId = vpcId,
        vpcRegion = vpcRegion,
        zoneId = zoneId,
    )
}
