@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ZoneArgs.builder
import com.pulumi.aws.route53.kotlin.inputs.ZoneVpcArgs
import com.pulumi.aws.route53.kotlin.inputs.ZoneVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Route53 Hosted Zone. For managing Domain Name System Security Extensions (DNSSEC), see the `aws.route53.KeySigningKey` and `aws.route53.HostedZoneDnsSec` resources.
 * ## Example Usage
 * ### Public Zone
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Zone("primary");
 *     }
 * }
 * ```
 * ### Public Subdomain Zone
 * For use in subdomains, note that you need to create a
 * `aws.route53.Record` of type `NS` as well as the subdomain
 * zone.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Zone("main");
 *         var dev = new Zone("dev", ZoneArgs.builder()
 *             .tags(Map.of("Environment", "dev"))
 *             .build());
 *         var dev_ns = new Record("dev-ns", RecordArgs.builder()
 *             .zoneId(main.zoneId())
 *             .name("dev.example.com")
 *             .type("NS")
 *             .ttl("30")
 *             .records(dev.nameServers())
 *             .build());
 *     }
 * }
 * ```
 * ### Private Zone
 * > **NOTE:** This provider provides both exclusive VPC associations defined in-line in this resource via `vpc` configuration blocks and a separate `Zone VPC Association resource. At this time, you cannot use in-line VPC associations in conjunction with any `aws.route53.ZoneAssociation` resources with the same zone ID otherwise it will cause a perpetual difference in plan output. You can optionally use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) to manage additional associations via the `aws.route53.ZoneAssociation` resource.
 * > **NOTE:** Private zones require at least one VPC association at all times.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.inputs.ZoneVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var private_ = new Zone("private", ZoneArgs.builder()
 *             .vpcs(ZoneVpcArgs.builder()
 *                 .vpcId(aws_vpc.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Route53 Zones using the zone `id`. For example:
 * ```sh
 *  $ pulumi import aws:route53/zone:Zone myzone Z1D633PJN98FT9
 * ```
 * @property comment A comment for the hosted zone. Defaults to 'Managed by Pulumi'.
 * @property delegationSetId The ID of the reusable delegation set whose NS records you want to assign to the hosted zone. Conflicts with `vpc` as delegation sets can only be used for public zones.
 * @property forceDestroy Whether to destroy all records (possibly managed outside of this provider) in the zone when destroying the zone.
 * @property name This is the name of the hosted zone.
 * @property tags A mapping of tags to assign to the zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcs Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
 */
public data class ZoneArgs(
    public val comment: Output<String>? = null,
    public val delegationSetId: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcs: Output<List<ZoneVpcArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ZoneArgs> {
    override fun toJava(): com.pulumi.aws.route53.ZoneArgs = com.pulumi.aws.route53.ZoneArgs.builder()
        .comment(comment?.applyValue({ args0 -> args0 }))
        .delegationSetId(delegationSetId?.applyValue({ args0 -> args0 }))
        .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .vpcs(
            vpcs?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [ZoneArgs].
 */
@PulumiTagMarker
public class ZoneArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var delegationSetId: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcs: Output<List<ZoneVpcArgs>>? = null

    /**
     * @param value A comment for the hosted zone. Defaults to 'Managed by Pulumi'.
     */
    @JvmName("qeapuprctknchdla")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The ID of the reusable delegation set whose NS records you want to assign to the hosted zone. Conflicts with `vpc` as delegation sets can only be used for public zones.
     */
    @JvmName("bqqemulpvseqhvok")
    public suspend fun delegationSetId(`value`: Output<String>) {
        this.delegationSetId = value
    }

    /**
     * @param value Whether to destroy all records (possibly managed outside of this provider) in the zone when destroying the zone.
     */
    @JvmName("fctiyolvdowtmvrj")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value This is the name of the hosted zone.
     */
    @JvmName("waqynhxtvieqtlxa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A mapping of tags to assign to the zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("smpiuyjsactkeucl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("foadardghkqcmtxe")
    public suspend fun vpcs(`value`: Output<List<ZoneVpcArgs>>) {
        this.vpcs = value
    }

    @JvmName("phfabxjbyybvswab")
    public suspend fun vpcs(vararg values: Output<ZoneVpcArgs>) {
        this.vpcs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("ojkosdualbrsdcmy")
    public suspend fun vpcs(values: List<Output<ZoneVpcArgs>>) {
        this.vpcs = Output.all(values)
    }

    /**
     * @param value A comment for the hosted zone. Defaults to 'Managed by Pulumi'.
     */
    @JvmName("oenofypcyaackkog")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The ID of the reusable delegation set whose NS records you want to assign to the hosted zone. Conflicts with `vpc` as delegation sets can only be used for public zones.
     */
    @JvmName("mocaxxaaydaguqfn")
    public suspend fun delegationSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegationSetId = mapped
    }

    /**
     * @param value Whether to destroy all records (possibly managed outside of this provider) in the zone when destroying the zone.
     */
    @JvmName("uahwjhctbflkdsji")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value This is the name of the hosted zone.
     */
    @JvmName("jwcnxasdjiqwuemk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A mapping of tags to assign to the zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jnqwkdbhqdpvnrqc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the zone. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugxsqtynrxvtphjx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("jfissgqtdjxbacyx")
    public suspend fun vpcs(`value`: List<ZoneVpcArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcs = mapped
    }

    /**
     * @param argument Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("lkauctjpwfnqofvd")
    public suspend fun vpcs(argument: List<suspend ZoneVpcArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ZoneVpcArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param argument Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("owvosbhurvvuklxw")
    public suspend fun vpcs(vararg argument: suspend ZoneVpcArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ZoneVpcArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param argument Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("srjymqlesagedoqs")
    public suspend fun vpcs(argument: suspend ZoneVpcArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ZoneVpcArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param values Configuration block(s) specifying VPC(s) to associate with a private hosted zone. Conflicts with the `delegation_set_id` argument in this resource and any `aws.route53.ZoneAssociation` resource specifying the same zone ID. Detailed below.
     */
    @JvmName("kscdvqiorpkvbavv")
    public suspend fun vpcs(vararg values: ZoneVpcArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcs = mapped
    }

    internal fun build(): ZoneArgs = ZoneArgs(
        comment = comment,
        delegationSetId = delegationSetId,
        forceDestroy = forceDestroy,
        name = name,
        tags = tags,
        vpcs = vpcs,
    )
}
