@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ZoneAssociation].
 */
@PulumiTagMarker
public class ZoneAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ZoneAssociationArgs = ZoneAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ZoneAssociationArgsBuilder.() -> Unit) {
        val builder = ZoneAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ZoneAssociation {
        val builtJavaResource = com.pulumi.aws.route53.ZoneAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ZoneAssociation(builtJavaResource)
    }
}

/**
 * Manages a Route53 Hosted Zone VPC association. VPC associations can only be made on private zones. See the `aws.route53.VpcAssociationAuthorization` resource for setting up cross-account associations.
 * > **NOTE:** Unless explicit association ordering is required (e.g., a separate cross-account association authorization), usage of this resource is not recommended. Use the `vpc` configuration blocks available within the `aws.route53.Zone` resource instead.
 * > **NOTE:** This provider provides both this standalone Zone VPC Association resource and exclusive VPC associations defined in-line in the `aws.route53.Zone` resource via `vpc` configuration blocks. At this time, you cannot use those in-line VPC associations in conjunction with this resource and the same zone ID otherwise it will cause a perpetual difference in plan output. You can optionally use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) in the `aws.route53.Zone` resource to manage additional associations via this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.inputs.ZoneVpcArgs;
 * import com.pulumi.aws.route53.ZoneAssociation;
 * import com.pulumi.aws.route53.ZoneAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Vpc("primary", VpcArgs.builder()
 *             .cidrBlock("10.6.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build());
 *         var secondaryVpc = new Vpc("secondaryVpc", VpcArgs.builder()
 *             .cidrBlock("10.7.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build());
 *         var example = new Zone("example", ZoneArgs.builder()
 *             .vpcs(ZoneVpcArgs.builder()
 *                 .vpcId(primary.id())
 *                 .build())
 *             .build());
 *         var secondaryZoneAssociation = new ZoneAssociation("secondaryZoneAssociation", ZoneAssociationArgs.builder()
 *             .zoneId(example.zoneId())
 *             .vpcId(secondaryVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * The VPC is _not_ in the same region where you have configured the AWS Provider:
 * __Using `pulumi import` to import__ Route 53 Hosted Zone Associations using the Hosted Zone ID and VPC ID, separated by a colon (`:`). For example:
 * The VPC is in the same region where you have configured the AWS Provider:
 * ```sh
 *  $ pulumi import aws:route53/zoneAssociation:ZoneAssociation example Z123456ABCDEFG:vpc-12345678
 * ```
 *  The VPC is _not_ in the same region where you have configured the AWS Provider:
 * ```sh
 *  $ pulumi import aws:route53/zoneAssociation:ZoneAssociation example Z123456ABCDEFG:vpc-12345678:us-east-2
 * ```
 *
 */
public class ZoneAssociation internal constructor(
    override val javaResource: com.pulumi.aws.route53.ZoneAssociation,
) : KotlinCustomResource(javaResource, ZoneAssociationMapper) {
    /**
     * The account ID of the account that created the hosted zone.
     */
    public val owningAccount: Output<String>
        get() = javaResource.owningAccount().applyValue({ args0 -> args0 })

    /**
     * The VPC to associate with the private hosted zone.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The VPC's region. Defaults to the region of the AWS provider.
     */
    public val vpcRegion: Output<String>
        get() = javaResource.vpcRegion().applyValue({ args0 -> args0 })

    /**
     * The private hosted zone to associate.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ZoneAssociationMapper : ResourceMapper<ZoneAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.route53.ZoneAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ZoneAssociation = ZoneAssociation(
        javaResource as
            com.pulumi.aws.route53.ZoneAssociation,
    )
}

/**
 * @see [ZoneAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ZoneAssociation].
 */
public suspend fun zoneAssociation(
    name: String,
    block: suspend ZoneAssociationResourceBuilder.() -> Unit,
): ZoneAssociation {
    val builder = ZoneAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ZoneAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun zoneAssociation(name: String): ZoneAssociation {
    val builder = ZoneAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
