@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin

import com.pulumi.aws.route53.ZoneAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Route53 Hosted Zone VPC association. VPC associations can only be made on private zones. See the `aws.route53.VpcAssociationAuthorization` resource for setting up cross-account associations.
 * > **NOTE:** Unless explicit association ordering is required (e.g., a separate cross-account association authorization), usage of this resource is not recommended. Use the `vpc` configuration blocks available within the `aws.route53.Zone` resource instead.
 * > **NOTE:** This provider provides both this standalone Zone VPC Association resource and exclusive VPC associations defined in-line in the `aws.route53.Zone` resource via `vpc` configuration blocks. At this time, you cannot use those in-line VPC associations in conjunction with this resource and the same zone ID otherwise it will cause a perpetual difference in plan output. You can optionally use [`ignoreChanges`](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) in the `aws.route53.Zone` resource to manage additional associations via this resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.Zone;
 * import com.pulumi.aws.route53.ZoneArgs;
 * import com.pulumi.aws.route53.inputs.ZoneVpcArgs;
 * import com.pulumi.aws.route53.ZoneAssociation;
 * import com.pulumi.aws.route53.ZoneAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Vpc("primary", VpcArgs.builder()
 *             .cidrBlock("10.6.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build());
 *         var secondaryVpc = new Vpc("secondaryVpc", VpcArgs.builder()
 *             .cidrBlock("10.7.0.0/16")
 *             .enableDnsHostnames(true)
 *             .enableDnsSupport(true)
 *             .build());
 *         var example = new Zone("example", ZoneArgs.builder()
 *             .vpcs(ZoneVpcArgs.builder()
 *                 .vpcId(primary.id())
 *                 .build())
 *             .build());
 *         var secondaryZoneAssociation = new ZoneAssociation("secondaryZoneAssociation", ZoneAssociationArgs.builder()
 *             .zoneId(example.zoneId())
 *             .vpcId(secondaryVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * The VPC is _not_ in the same region where you have configured the AWS Provider:
 * __Using `pulumi import` to import__ Route 53 Hosted Zone Associations using the Hosted Zone ID and VPC ID, separated by a colon (`:`). For example:
 * The VPC is in the same region where you have configured the AWS Provider:
 * ```sh
 *  $ pulumi import aws:route53/zoneAssociation:ZoneAssociation example Z123456ABCDEFG:vpc-12345678
 * ```
 *  The VPC is _not_ in the same region where you have configured the AWS Provider:
 * ```sh
 *  $ pulumi import aws:route53/zoneAssociation:ZoneAssociation example Z123456ABCDEFG:vpc-12345678:us-east-2
 * ```
 * @property vpcId The VPC to associate with the private hosted zone.
 * @property vpcRegion The VPC's region. Defaults to the region of the AWS provider.
 * @property zoneId The private hosted zone to associate.
 */
public data class ZoneAssociationArgs(
    public val vpcId: Output<String>? = null,
    public val vpcRegion: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.ZoneAssociationArgs> {
    override fun toJava(): com.pulumi.aws.route53.ZoneAssociationArgs =
        com.pulumi.aws.route53.ZoneAssociationArgs.builder()
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcRegion(vpcRegion?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneAssociationArgs].
 */
@PulumiTagMarker
public class ZoneAssociationArgsBuilder internal constructor() {
    private var vpcId: Output<String>? = null

    private var vpcRegion: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The VPC to associate with the private hosted zone.
     */
    @JvmName("pvjubfhybnkdreru")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The VPC's region. Defaults to the region of the AWS provider.
     */
    @JvmName("vkbgkixadoucqjlr")
    public suspend fun vpcRegion(`value`: Output<String>) {
        this.vpcRegion = value
    }

    /**
     * @param value The private hosted zone to associate.
     */
    @JvmName("slkcqsolcrmskbhr")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The VPC to associate with the private hosted zone.
     */
    @JvmName("halatceieyooqwro")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The VPC's region. Defaults to the region of the AWS provider.
     */
    @JvmName("ixhflvgygaoutcbs")
    public suspend fun vpcRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcRegion = mapped
    }

    /**
     * @param value The private hosted zone to associate.
     */
    @JvmName("lsqweqmwrpmukthq")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ZoneAssociationArgs = ZoneAssociationArgs(
        vpcId = vpcId,
        vpcRegion = vpcRegion,
        zoneId = zoneId,
    )
}
