@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetQueryLogConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueryLogConfig.
 * @property filters One or more name/value pairs to use as filters. There are
 * several valid keys, for a full reference, check out
 * [Route53resolver Filter value in the AWS API reference][1].
 * In addition to all arguments above, the following attributes are exported:
 * @property name The name of the query logging configuration.
 * @property resolverQueryLogConfigId ID of the Route53 Resolver Query Logging Configuration.
 * @property tags Map of tags to assign to the service.
 * [1]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_Filter.html
 */
public data class GetQueryLogConfigPlainArgs(
    public val filters: List<GetQueryLogConfigFilter>? = null,
    public val name: String? = null,
    public val resolverQueryLogConfigId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetQueryLogConfigPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetQueryLogConfigPlainArgs =
        com.pulumi.aws.route53.inputs.GetQueryLogConfigPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name?.let({ args0 -> args0 }))
            .resolverQueryLogConfigId(resolverQueryLogConfigId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetQueryLogConfigPlainArgs].
 */
@PulumiTagMarker
public class GetQueryLogConfigPlainArgsBuilder internal constructor() {
    private var filters: List<GetQueryLogConfigFilter>? = null

    private var name: String? = null

    private var resolverQueryLogConfigId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("pejnbhjbghbeqyug")
    public suspend fun filters(`value`: List<GetQueryLogConfigFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("kjvebkoqpoyrhgpv")
    public suspend fun filters(argument: List<suspend GetQueryLogConfigFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetQueryLogConfigFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("rfsnlmrulytpyfvl")
    public suspend fun filters(vararg argument: suspend GetQueryLogConfigFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetQueryLogConfigFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("qhidubmjqupvosha")
    public suspend fun filters(argument: suspend GetQueryLogConfigFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetQueryLogConfigFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [Route53resolver Filter value in the AWS API reference][1].
     * In addition to all arguments above, the following attributes are exported:
     */
    @JvmName("fmhwuevyxtnelvxj")
    public suspend fun filters(vararg values: GetQueryLogConfigFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value The name of the query logging configuration.
     */
    @JvmName("lvomloxhpyfnmtse")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value ID of the Route53 Resolver Query Logging Configuration.
     */
    @JvmName("vdojuvpmmsfsetfh")
    public suspend fun resolverQueryLogConfigId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resolverQueryLogConfigId = mapped
    }

    /**
     * @param value Map of tags to assign to the service.
     * [1]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_Filter.html
     */
    @JvmName("qrtfqhsxtblvukmh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the service.
     * [1]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_Filter.html
     */
    @JvmName("fwhbredngbbyclfv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetQueryLogConfigPlainArgs = GetQueryLogConfigPlainArgs(
        filters = filters,
        name = name,
        resolverQueryLogConfigId = resolverQueryLogConfigId,
        tags = tags,
    )
}
