@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverFirewallDomainListPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverFirewallDomainList.
 * @property firewallDomainListId The ID of the domain list.
 * The following attribute is additionally exported:
 */
public data class GetResolverFirewallDomainListPlainArgs(
    public val firewallDomainListId: String,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverFirewallDomainListPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetResolverFirewallDomainListPlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverFirewallDomainListPlainArgs.builder()
            .firewallDomainListId(firewallDomainListId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverFirewallDomainListPlainArgs].
 */
@PulumiTagMarker
public class GetResolverFirewallDomainListPlainArgsBuilder internal constructor() {
    private var firewallDomainListId: String? = null

    /**
     * @param value The ID of the domain list.
     * The following attribute is additionally exported:
     */
    @JvmName("itscvuhvgnqmsmvr")
    public suspend fun firewallDomainListId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallDomainListId = mapped
    }

    internal fun build(): GetResolverFirewallDomainListPlainArgs =
        GetResolverFirewallDomainListPlainArgs(
            firewallDomainListId = firewallDomainListId ?: throw
                PulumiNullFieldException("firewallDomainListId"),
        )
}
