@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverFirewallRuleGroupAssociation.
 * @property firewallRuleGroupAssociationId The identifier for the association.
 * The following attribute is additionally exported:
 */
public data class GetResolverFirewallRuleGroupAssociationPlainArgs(
    public val firewallRuleGroupAssociationId: String,
) :
    ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupAssociationPlainArgs> {
    override fun toJava():
        com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupAssociationPlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverFirewallRuleGroupAssociationPlainArgs.builder()
            .firewallRuleGroupAssociationId(firewallRuleGroupAssociationId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverFirewallRuleGroupAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetResolverFirewallRuleGroupAssociationPlainArgsBuilder internal constructor() {
    private var firewallRuleGroupAssociationId: String? = null

    /**
     * @param value The identifier for the association.
     * The following attribute is additionally exported:
     */
    @JvmName("edguivdcqacxrwcq")
    public suspend fun firewallRuleGroupAssociationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleGroupAssociationId = mapped
    }

    internal fun build(): GetResolverFirewallRuleGroupAssociationPlainArgs =
        GetResolverFirewallRuleGroupAssociationPlainArgs(
            firewallRuleGroupAssociationId = firewallRuleGroupAssociationId ?: throw
                PulumiNullFieldException("firewallRuleGroupAssociationId"),
        )
}
