@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetResolverFirewallRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolverFirewallRules.
 * @property action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
 * @property firewallRuleGroupId The unique identifier of the firewall rule group that you want to retrieve the rules for.
 * @property priority The setting that determines the processing order of the rules in a rule group.
 */
public data class GetResolverFirewallRulesPlainArgs(
    public val action: String? = null,
    public val firewallRuleGroupId: String,
    public val priority: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetResolverFirewallRulesPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetResolverFirewallRulesPlainArgs =
        com.pulumi.aws.route53.inputs.GetResolverFirewallRulesPlainArgs.builder()
            .action(action?.let({ args0 -> args0 }))
            .firewallRuleGroupId(firewallRuleGroupId.let({ args0 -> args0 }))
            .priority(priority?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolverFirewallRulesPlainArgs].
 */
@PulumiTagMarker
public class GetResolverFirewallRulesPlainArgsBuilder internal constructor() {
    private var action: String? = null

    private var firewallRuleGroupId: String? = null

    private var priority: Int? = null

    /**
     * @param value The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list.
     */
    @JvmName("jdxxokfaoercvyqk")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.action = mapped
    }

    /**
     * @param value The unique identifier of the firewall rule group that you want to retrieve the rules for.
     */
    @JvmName("dmiryctolbbwxlbb")
    public suspend fun firewallRuleGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleGroupId = mapped
    }

    /**
     * @param value The setting that determines the processing order of the rules in a rule group.
     */
    @JvmName("jkworhukrnqwvwli")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.priority = mapped
    }

    internal fun build(): GetResolverFirewallRulesPlainArgs = GetResolverFirewallRulesPlainArgs(
        action = action,
        firewallRuleGroupId = firewallRuleGroupId ?: throw PulumiNullFieldException("firewallRuleGroupId"),
        priority = priority,
    )
}
