@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrafficPolicyDocument.
 * @property endpoints Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
 * @property recordType DNS type of all of the resource record sets that Amazon Route 53 will create based on this traffic policy.
 * @property rules Configuration block for definitions of the rules that you want to use in this traffic policy. See below
 * @property startEndpoint An endpoint to be as the starting point for the traffic policy.
 * @property startRule A rule to be as the starting point for the traffic policy.
 * @property version Version of the traffic policy format.
 */
public data class GetTrafficPolicyDocumentPlainArgs(
    public val endpoints: List<GetTrafficPolicyDocumentEndpoint>? = null,
    public val recordType: String? = null,
    public val rules: List<GetTrafficPolicyDocumentRule>? = null,
    public val startEndpoint: String? = null,
    public val startRule: String? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentPlainArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentPlainArgs =
        com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentPlainArgs.builder()
            .endpoints(endpoints?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .recordType(recordType?.let({ args0 -> args0 }))
            .rules(rules?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .startEndpoint(startEndpoint?.let({ args0 -> args0 }))
            .startRule(startRule?.let({ args0 -> args0 }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficPolicyDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetTrafficPolicyDocumentPlainArgsBuilder internal constructor() {
    private var endpoints: List<GetTrafficPolicyDocumentEndpoint>? = null

    private var recordType: String? = null

    private var rules: List<GetTrafficPolicyDocumentRule>? = null

    private var startEndpoint: String? = null

    private var startRule: String? = null

    private var version: String? = null

    /**
     * @param value Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
     */
    @JvmName("nobawthjegqnvhik")
    public suspend fun endpoints(`value`: List<GetTrafficPolicyDocumentEndpoint>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpoints = mapped
    }

    /**
     * @param argument Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
     */
    @JvmName("rokchgnsfpkmaopv")
    public suspend
    fun endpoints(argument: List<suspend GetTrafficPolicyDocumentEndpointBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentEndpointBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.endpoints = mapped
    }

    /**
     * @param argument Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
     */
    @JvmName("rmbqfftrfcachvue")
    public suspend fun endpoints(
        vararg
        argument: suspend GetTrafficPolicyDocumentEndpointBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentEndpointBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.endpoints = mapped
    }

    /**
     * @param argument Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
     */
    @JvmName("lbnfqcikfkeddjif")
    public suspend
    fun endpoints(argument: suspend GetTrafficPolicyDocumentEndpointBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTrafficPolicyDocumentEndpointBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.endpoints = mapped
    }

    /**
     * @param values Configuration block for the definitions of the endpoints that you want to use in this traffic policy. See below
     */
    @JvmName("qineaestuomlpptx")
    public suspend fun endpoints(vararg values: GetTrafficPolicyDocumentEndpoint) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpoints = mapped
    }

    /**
     * @param value DNS type of all of the resource record sets that Amazon Route 53 will create based on this traffic policy.
     */
    @JvmName("ketfqrughmckmobx")
    public suspend fun recordType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.recordType = mapped
    }

    /**
     * @param value Configuration block for definitions of the rules that you want to use in this traffic policy. See below
     */
    @JvmName("lkqmqeotqhpsmwdh")
    public suspend fun rules(`value`: List<GetTrafficPolicyDocumentRule>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rules = mapped
    }

    /**
     * @param argument Configuration block for definitions of the rules that you want to use in this traffic policy. See below
     */
    @JvmName("xerswvbquuqymynw")
    public suspend fun rules(argument: List<suspend GetTrafficPolicyDocumentRuleBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.rules = mapped
    }

    /**
     * @param argument Configuration block for definitions of the rules that you want to use in this traffic policy. See below
     */
    @JvmName("bmoxyucwvtdpnyjn")
    public suspend fun rules(
        vararg
        argument: suspend GetTrafficPolicyDocumentRuleBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetTrafficPolicyDocumentRuleBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.rules = mapped
    }

    /**
     * @param argument Configuration block for definitions of the rules that you want to use in this traffic policy. See below
     */
    @JvmName("bkcwltukdnmejbhy")
    public suspend fun rules(argument: suspend GetTrafficPolicyDocumentRuleBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetTrafficPolicyDocumentRuleBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.rules = mapped
    }

    /**
     * @param values Configuration block for definitions of the rules that you want to use in this traffic policy. See below
     */
    @JvmName("urwbljtlngghvyub")
    public suspend fun rules(vararg values: GetTrafficPolicyDocumentRule) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rules = mapped
    }

    /**
     * @param value An endpoint to be as the starting point for the traffic policy.
     */
    @JvmName("kwencbcsgxovbufv")
    public suspend fun startEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startEndpoint = mapped
    }

    /**
     * @param value A rule to be as the starting point for the traffic policy.
     */
    @JvmName("aueieirugpnjlpas")
    public suspend fun startRule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startRule = mapped
    }

    /**
     * @param value Version of the traffic policy format.
     */
    @JvmName("lwyssgbuxbtqrmqe")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetTrafficPolicyDocumentPlainArgs = GetTrafficPolicyDocumentPlainArgs(
        endpoints = endpoints,
        recordType = recordType,
        rules = rules,
        startEndpoint = startEndpoint,
        startRule = startRule,
        version = version,
    )
}
