@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleRegion.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointReference References to an endpoint.
 * @property evaluateTargetHealth Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
 * @property healthCheck If you want to associate a health check with the endpoint or rule.
 * @property region Region code for the AWS Region that you created the resource in.
 * @property ruleReference References to a rule.
 */
public data class GetTrafficPolicyDocumentRuleRegion(
    public val endpointReference: String? = null,
    public val evaluateTargetHealth: Boolean? = null,
    public val healthCheck: String? = null,
    public val region: String? = null,
    public val ruleReference: String? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleRegion> {
    override fun toJava(): com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleRegion =
        com.pulumi.aws.route53.inputs.GetTrafficPolicyDocumentRuleRegion.builder()
            .endpointReference(endpointReference?.let({ args0 -> args0 }))
            .evaluateTargetHealth(evaluateTargetHealth?.let({ args0 -> args0 }))
            .healthCheck(healthCheck?.let({ args0 -> args0 }))
            .region(region?.let({ args0 -> args0 }))
            .ruleReference(ruleReference?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficPolicyDocumentRuleRegion].
 */
@PulumiTagMarker
public class GetTrafficPolicyDocumentRuleRegionBuilder internal constructor() {
    private var endpointReference: String? = null

    private var evaluateTargetHealth: Boolean? = null

    private var healthCheck: String? = null

    private var region: String? = null

    private var ruleReference: String? = null

    /**
     * @param value References to an endpoint.
     */
    @JvmName("mkgkwagbswwssbrn")
    public suspend fun endpointReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointReference = mapped
    }

    /**
     * @param value Indicates whether you want Amazon Route 53 to evaluate the health of the endpoint and route traffic only to healthy endpoints.
     */
    @JvmName("omthgrvpcetdypty")
    public suspend fun evaluateTargetHealth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.evaluateTargetHealth = mapped
    }

    /**
     * @param value If you want to associate a health check with the endpoint or rule.
     */
    @JvmName("durmcjcncwlbbpvu")
    public suspend fun healthCheck(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.healthCheck = mapped
    }

    /**
     * @param value Region code for the AWS Region that you created the resource in.
     */
    @JvmName("phfktlhblduneypv")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value References to a rule.
     */
    @JvmName("sqrpvcopcxibmimg")
    public suspend fun ruleReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ruleReference = mapped
    }

    internal fun build(): GetTrafficPolicyDocumentRuleRegion = GetTrafficPolicyDocumentRuleRegion(
        endpointReference = endpointReference,
        evaluateTargetHealth = evaluateTargetHealth,
        healthCheck = healthCheck,
        region = region,
        ruleReference = ruleReference,
    )
}
