@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.RecordGeolocationRoutingPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property continent A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
 * @property country A two-character country code or `*` to indicate a default resource record set.
 * @property subdivision A subdivision code for a country.
 */
public data class RecordGeolocationRoutingPolicyArgs(
    public val continent: Output<String>? = null,
    public val country: Output<String>? = null,
    public val subdivision: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.RecordGeolocationRoutingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.RecordGeolocationRoutingPolicyArgs =
        com.pulumi.aws.route53.inputs.RecordGeolocationRoutingPolicyArgs.builder()
            .continent(continent?.applyValue({ args0 -> args0 }))
            .country(country?.applyValue({ args0 -> args0 }))
            .subdivision(subdivision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordGeolocationRoutingPolicyArgs].
 */
@PulumiTagMarker
public class RecordGeolocationRoutingPolicyArgsBuilder internal constructor() {
    private var continent: Output<String>? = null

    private var country: Output<String>? = null

    private var subdivision: Output<String>? = null

    /**
     * @param value A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
     */
    @JvmName("lurmpfjficjmvycb")
    public suspend fun continent(`value`: Output<String>) {
        this.continent = value
    }

    /**
     * @param value A two-character country code or `*` to indicate a default resource record set.
     */
    @JvmName("ipvncavuyfxitrmm")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value A subdivision code for a country.
     */
    @JvmName("ldkmsvnajkbkrrty")
    public suspend fun subdivision(`value`: Output<String>) {
        this.subdivision = value
    }

    /**
     * @param value A two-letter continent code. See http://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html for code details. Either `continent` or `country` must be specified.
     */
    @JvmName("swsfkdksvfgaxubi")
    public suspend fun continent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continent = mapped
    }

    /**
     * @param value A two-character country code or `*` to indicate a default resource record set.
     */
    @JvmName("ymvpiawfbcsoxjdt")
    public suspend fun country(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value A subdivision code for a country.
     */
    @JvmName("ncxcrphdqgrdkfth")
    public suspend fun subdivision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdivision = mapped
    }

    internal fun build(): RecordGeolocationRoutingPolicyArgs = RecordGeolocationRoutingPolicyArgs(
        continent = continent,
        country = country,
        subdivision = subdivision,
    )
}
