@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.ResolverEndpointIpAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ip The IP address in the subnet that you want to use for DNS queries.
 * @property ipId
 * @property subnetId The ID of the subnet that contains the IP address.
 */
public data class ResolverEndpointIpAddressArgs(
    public val ip: Output<String>? = null,
    public val ipId: Output<String>? = null,
    public val subnetId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.ResolverEndpointIpAddressArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.ResolverEndpointIpAddressArgs =
        com.pulumi.aws.route53.inputs.ResolverEndpointIpAddressArgs.builder()
            .ip(ip?.applyValue({ args0 -> args0 }))
            .ipId(ipId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverEndpointIpAddressArgs].
 */
@PulumiTagMarker
public class ResolverEndpointIpAddressArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var ipId: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The IP address in the subnet that you want to use for DNS queries.
     */
    @JvmName("cgwbffvpxyojwhuf")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value
     */
    @JvmName("crskbpnecdceufna")
    public suspend fun ipId(`value`: Output<String>) {
        this.ipId = value
    }

    /**
     * @param value The ID of the subnet that contains the IP address.
     */
    @JvmName("xeigdqyvalaamgdp")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The IP address in the subnet that you want to use for DNS queries.
     */
    @JvmName("qrivplhjltvcouaj")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value
     */
    @JvmName("uuwawaimcyhnubwe")
    public suspend fun ipId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipId = mapped
    }

    /**
     * @param value The ID of the subnet that contains the IP address.
     */
    @JvmName("hkijxkvpfennvdot")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): ResolverEndpointIpAddressArgs = ResolverEndpointIpAddressArgs(
        ip = ip,
        ipId = ipId,
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
    )
}
