@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.inputs

import com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ip One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
 * @property port The port at `ip` that you want to forward DNS queries to. Default value is `53`
 */
public data class ResolverRuleTargetIpArgs(
    public val ip: Output<String>,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs> {
    override fun toJava(): com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs =
        com.pulumi.aws.route53.inputs.ResolverRuleTargetIpArgs.builder()
            .ip(ip.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResolverRuleTargetIpArgs].
 */
@PulumiTagMarker
public class ResolverRuleTargetIpArgsBuilder internal constructor() {
    private var ip: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
     */
    @JvmName("tdttouieusabkxdx")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value The port at `ip` that you want to forward DNS queries to. Default value is `53`
     */
    @JvmName("eekegpjivxlyvfac")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
     */
    @JvmName("emlnuwwpmllbydcn")
    public suspend fun ip(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param value The port at `ip` that you want to forward DNS queries to. Default value is `53`
     */
    @JvmName("hqvuveotmxtrjclb")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): ResolverRuleTargetIpArgs = ResolverRuleTargetIpArgs(
        ip = ip ?: throw PulumiNullFieldException("ip"),
        port = port,
    )
}
