@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDelegationSet.
 * @property arn
 * @property callerReference
 * @property id
 * @property nameServers
 */
public data class GetDelegationSetResult(
    public val arn: String,
    public val callerReference: String,
    public val id: String,
    public val nameServers: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetDelegationSetResult):
            GetDelegationSetResult = GetDelegationSetResult(
            arn = javaType.arn(),
            callerReference = javaType.callerReference(),
            id = javaType.id(),
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
        )
    }
}
