@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getQueryLogConfig.
 * @property arn
 * @property destinationArn
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property ownerId
 * @property resolverQueryLogConfigId
 * @property shareStatus
 * @property tags
 */
public data class GetQueryLogConfigResult(
    public val arn: String,
    public val destinationArn: String,
    public val filters: List<GetQueryLogConfigFilter>? = null,
    public val id: String,
    public val name: String? = null,
    public val ownerId: String,
    public val resolverQueryLogConfigId: String? = null,
    public val shareStatus: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetQueryLogConfigResult):
            GetQueryLogConfigResult = GetQueryLogConfigResult(
            arn = javaType.arn(),
            destinationArn = javaType.destinationArn(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.route53.kotlin.outputs.GetQueryLogConfigFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ownerId = javaType.ownerId(),
            resolverQueryLogConfigId = javaType.resolverQueryLogConfigId().map({ args0 -> args0 }).orElse(null),
            shareStatus = javaType.shareStatus(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
