@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.route53.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResolverFirewallDomainList.
 * @property arn
 * @property creationTime
 * @property creatorRequestId
 * @property domainCount
 * @property firewallDomainListId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property managedOwnerName
 * @property modificationTime
 * @property name
 * @property status
 * @property statusMessage
 */
public data class GetResolverFirewallDomainListResult(
    public val arn: String,
    public val creationTime: String,
    public val creatorRequestId: String,
    public val domainCount: Int,
    public val firewallDomainListId: String,
    public val id: String,
    public val managedOwnerName: String,
    public val modificationTime: String,
    public val name: String,
    public val status: String,
    public val statusMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.route53.outputs.GetResolverFirewallDomainListResult):
            GetResolverFirewallDomainListResult = GetResolverFirewallDomainListResult(
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            creatorRequestId = javaType.creatorRequestId(),
            domainCount = javaType.domainCount(),
            firewallDomainListId = javaType.firewallDomainListId(),
            id = javaType.id(),
            managedOwnerName = javaType.managedOwnerName(),
            modificationTime = javaType.modificationTime(),
            name = javaType.name(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
